/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.schemas.rowiterator;

import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowCollection;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.XmlReaderOptions;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.AbstractListIterator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.xml.stream.XMLStreamException;

public class XmlRowIteratorHandler
implements RowIteratorHandler {
    private File file = null;
    private RowValueConverter rowValueConverter = null;

    public XmlRowIteratorHandler(File file) {
        this.file = file;
        this.rowValueConverter = (r, c, v) -> v;
    }

    public XmlRowIteratorHandler(File file, RowValueConverter rowValueConverter) {
        this.file = file;
        this.rowValueConverter = rowValueConverter;
    }

    @Override
    public Iterator<Row> iterator(RowCollection c) {
        Table table = (Table)c.getParent().clone();
        LinkedBlockingDeque<Object> deque = new LinkedBlockingDeque<Object>(131072);
        Runnable r = this.loadXml(table, this.file, deque, 0);
        return new WrappedRowListIterator(r, table, deque);
    }

    private Runnable loadXml(Table table, File file, BlockingDeque<Object> deque, int index) {
        XmlReaderOptions options = new XmlReaderOptions();
        options.setRowValueConverter(this.rowValueConverter);
        int[] count = new int[]{0};
        options.setAddRow((t, r) -> {
            try {
                if (t == table) {
                    if (count[0] >= index) {
                        deque.put(r);
                    } else {
                        count[0] = count[0] + 1;
                    }
                } else {
                    deque.put((Object)DequeDummy.LAST);
                }
            }
            catch (InterruptedException e) {
                this.endDeque(deque);
            }
            return false;
        });
        Runnable r2 = () -> {
            try {
                table.loadXml(file, options);
            }
            catch (IOException | XMLStreamException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.endDeque(deque);
            }
        };
        return r2;
    }

    private void endDeque(BlockingDeque<Object> deque) {
        try {
            deque.put((Object)DequeDummy.LAST);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c, int index) {
        Table table = (Table)c.getParent().clone();
        LinkedBlockingDeque<Object> deque = new LinkedBlockingDeque<Object>(131072);
        Runnable r = this.loadXml(table, this.file, deque, index);
        return new WrappedRowListIterator(r, table, deque);
    }

    @Override
    public ListIterator<Row> listIterator(RowCollection c) {
        Table table = (Table)c.getParent().clone();
        LinkedBlockingDeque<Object> deque = new LinkedBlockingDeque<Object>(131072);
        Runnable r = this.loadXml(table, this.file, deque, 0);
        return new WrappedRowListIterator(r, table, deque);
    }

    static class WrappedRowListIterator
    extends AbstractListIterator {
        private final Thread thread;
        private boolean started = false;
        private final BlockingDeque<Object> deque;
        private Row current = null;

        protected WrappedRowListIterator(Runnable reader, Table table, BlockingDeque<Object> deque) {
            this.thread = new Thread(reader);
            this.deque = deque;
        }

        @Override
        public void close() throws Exception {
            if (!this.started) {
                this.thread.interrupt();
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.started) {
                this.thread.start();
                this.started = true;
            }
            if (this.current != null) {
                return true;
            }
            Object obj = null;
            try {
                obj = this.deque.take();
            }
            catch (InterruptedException e) {
                obj = null;
            }
            this.current = obj == DequeDummy.LAST ? null : (Row)obj;
            return this.current != null;
        }

        @Override
        public Row next() {
            Row ret = this.current;
            this.current = null;
            return ret;
        }
    }

    private static enum DequeDummy {
        LAST;

    }
}

