/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.exceptions;

import com.sqlapp.exceptions.SqlappException;

public class InvalidPropertyException
extends SqlappException {
    private static final long serialVersionUID = 107328200084629983L;
    private final String propertyName;
    private final Object propertyValue;
    private final Class<?> propertyClass;

    public InvalidPropertyException(String propertyName, Object propertyValue, Class<?> propertyClass, Throwable t) {
        super(InvalidPropertyException.createMessage(propertyName, propertyValue, propertyClass), t);
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.propertyClass = propertyClass;
    }

    public InvalidPropertyException(String propertyName, Object propertyValue, Class<?> propertyClass) {
        super(InvalidPropertyException.createMessage(propertyName, propertyValue, propertyClass));
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
        this.propertyClass = propertyClass;
    }

    private static String createMessage(String propertyName, Object propertyValue, Class<?> propertyClass) {
        StringBuilder builder = new StringBuilder();
        builder.append("propertyName=");
        builder.append(propertyName);
        builder.append(", propertyValue=");
        builder.append(propertyValue);
        if (propertyClass != null) {
            builder.append(", propertyClass=");
            builder.append(propertyClass);
        }
        return builder.toString();
    }

    public InvalidPropertyException(String propertyName, Object propertyValue) {
        this(propertyName, propertyValue, null);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }
}

