/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.DialectResolver;
import com.sqlapp.jdbc.AbstractJdbc;
import com.sqlapp.jdbc.SqlappDatabaseMetaData;
import com.sqlapp.jdbc.SqlappStatement;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.ThreadContext;

public abstract class AbstractConnection
extends AbstractJdbc<Connection>
implements Connection {
    private Dialect dialect = null;

    public AbstractConnection(Connection nativeConnection) {
        super(nativeConnection);
    }

    public Dialect getDialect() {
        if (this.dialect == null) {
            try {
                DatabaseMetaData databaseMetaData = ((Connection)this.nativeObject).getMetaData();
                this.dialect = DialectResolver.getInstance().getDialect(databaseMetaData);
            }
            catch (SQLException e) {
                this.error(this.getClass().getSimpleName() + "#getDialect()", e);
            }
        }
        return this.dialect;
    }

    @Override
    protected void logBefore() {
        if (this.dialect != null) {
            ThreadContext.put((String)"dialect", (String)this.dialect.toString());
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        ((Connection)this.nativeObject).clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        ((Connection)this.nativeObject).close();
    }

    @Override
    public void commit() throws SQLException {
        this.info("commit()");
        ((Connection)this.nativeObject).commit();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return ((Connection)this.nativeObject).createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return ((Connection)this.nativeObject).createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return ((Connection)this.nativeObject).createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return ((Connection)this.nativeObject).createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return ((Connection)this.nativeObject).createSQLXML();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new SqlappStatement(((Connection)this.nativeObject).createStatement(), (Connection)this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new SqlappStatement(((Connection)this.nativeObject).createStatement(resultSetType, resultSetConcurrency), (Connection)this);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new SqlappStatement(((Connection)this.nativeObject).createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), (Connection)this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return ((Connection)this.nativeObject).createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return ((Connection)this.nativeObject).getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return ((Connection)this.nativeObject).getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return ((Connection)this.nativeObject).getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return ((Connection)this.nativeObject).getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return ((Connection)this.nativeObject).getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = ((Connection)this.nativeObject).getMetaData();
        if (this.dialect == null) {
            this.dialect = DialectResolver.getInstance().getDialect(databaseMetaData);
        }
        if (databaseMetaData instanceof SqlappDatabaseMetaData) {
            return databaseMetaData;
        }
        return new SqlappDatabaseMetaData(databaseMetaData, this);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return ((Connection)this.nativeObject).getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return ((Connection)this.nativeObject).getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return ((Connection)this.nativeObject).getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return ((Connection)this.nativeObject).isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return ((Connection)this.nativeObject).isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return ((Connection)this.nativeObject).isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return ((Connection)this.nativeObject).nativeSQL(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (this.isInfoEnabled()) {
            this.info("releaseSavepoint(" + savepoint + ")");
        }
        ((Connection)this.nativeObject).releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.info("rollback()");
        ((Connection)this.nativeObject).rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.isInfoEnabled()) {
            this.info("rollback(" + savepoint + ")");
        }
        ((Connection)this.nativeObject).rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isTraceEnabled()) {
            this.trace("setAutoCommit(" + autoCommit + ")");
        }
        ((Connection)this.nativeObject).setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        ((Connection)this.nativeObject).setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        ((Connection)this.nativeObject).setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        ((Connection)this.nativeObject).setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (this.isTraceEnabled()) {
            this.trace("setHoldability(" + holdability + ")");
        }
        ((Connection)this.nativeObject).setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isTraceEnabled()) {
            this.trace("setReadOnly(" + readOnly + ")");
        }
        ((Connection)this.nativeObject).setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.trace("setSavepoint()");
        return ((Connection)this.nativeObject).setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (this.isTraceEnabled()) {
            this.trace("setSavepoint(" + name + ")");
        }
        return ((Connection)this.nativeObject).setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (this.isTraceEnabled()) {
            this.trace("setTransactionIsolation(" + level + ")");
        }
        ((Connection)this.nativeObject).setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        ((Connection)this.nativeObject).setTypeMap(map);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        ((Connection)this.nativeObject).setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return ((Connection)this.nativeObject).getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        ((Connection)this.nativeObject).abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        ((Connection)this.nativeObject).setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return ((Connection)this.nativeObject).getNetworkTimeout();
    }

    @Override
    public void beginRequest() throws SQLException {
        ((Connection)this.nativeObject).beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        ((Connection)this.nativeObject).endRequest();
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws SQLException {
        return ((Connection)this.nativeObject).setShardingKeyIfValid(shardingKey, superShardingKey, timeout);
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws SQLException {
        return ((Connection)this.nativeObject).setShardingKeyIfValid(shardingKey, timeout);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws SQLException {
        ((Connection)this.nativeObject).setShardingKey(shardingKey, superShardingKey);
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws SQLException {
        ((Connection)this.nativeObject).setShardingKey(shardingKey);
    }
}

