/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.util.CommonUtils;
import java.sql.SQLException;
import java.sql.Wrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public abstract class AbstractJdbc<T extends Wrapper>
implements Wrapper {
    private Logger logger = LogManager.getLogger(this.getClass());
    protected T nativeObject = null;
    private boolean debug = false;

    public AbstractJdbc(T nativeObject) {
        this.nativeObject = nativeObject;
    }

    public T getNativeObject() {
        return this.nativeObject;
    }

    protected void logBefore() {
    }

    protected void setMdc(String key, String val) {
        ThreadContext.put((String)key, (String)val);
    }

    protected void info(String text) {
        if (CommonUtils.isEmpty(text)) {
            return;
        }
        this.logBefore();
        this.logger.info(text);
        if (this.isDebug()) {
            System.out.println(text);
        }
    }

    protected void warn(String text) {
        if (CommonUtils.isEmpty(text)) {
            return;
        }
        this.logBefore();
        this.logger.warn(text);
        if (this.isDebug()) {
            System.out.println(text);
        }
    }

    protected void trace(String text) {
        if (CommonUtils.isEmpty(text)) {
            return;
        }
        this.logBefore();
        this.logger.trace(text);
    }

    protected void debug(String text) {
        if (CommonUtils.isEmpty(text)) {
            return;
        }
        this.logBefore();
        this.logger.debug(text);
    }

    protected void error(String text, Throwable t) {
        this.logBefore();
        this.logger.error(text, t);
        if (this.isDebug()) {
            if (CommonUtils.isEmpty(text)) {
                System.err.println(text);
            }
            t.printStackTrace(System.err);
        }
    }

    protected boolean isSqlLogEnabled() {
        return this.isDebug() || this.logger.isInfoEnabled();
    }

    protected boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    protected boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    protected boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        return this.nativeObject.isWrapperFor(iface);
    }

    public <S> S unwrap(Class<S> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (S)this;
        }
        return this.nativeObject.unwrap(iface);
    }

    protected boolean isDebug() {
        return this.debug;
    }

    protected void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected void initializeChild(AbstractJdbc<?> child) {
        child.setDebug(this.isDebug());
    }
}

