/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.jdbc.AbstractStatement;
import com.sqlapp.jdbc.SqlappConnection;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DateUtils;
import com.sqlapp.util.FlexList;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public abstract class AbstractPreparedStatement<T extends PreparedStatement>
extends AbstractStatement<T>
implements PreparedStatement {
    private final List<String> batchSqlList = CommonUtils.list();
    private final List<Object> parameters = new FlexList<Object>();
    private String[] sqlParts = null;
    private String sql = null;

    public AbstractPreparedStatement(T nativeStatement, String sql, SqlappConnection connection) {
        super(nativeStatement, connection);
        this.sql = sql;
        String[] parts = sql.split("[?]");
        this.sqlParts = parts;
    }

    private String getLogSql() {
        if (this.isSqlLogEnabled()) {
            StringBuilder builder = new StringBuilder(this.sql.length() * 2);
            int size = this.parameters.size();
            builder.append(this.sqlParts[0]);
            for (int i = 0; i < size; ++i) {
                builder.append(this.parameters.get(i));
                if (i + 1 >= this.sqlParts.length) continue;
                builder.append(this.sqlParts[i + 1]);
            }
            return builder.toString();
        }
        return "";
    }

    @Override
    public void addBatch() throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.batchSqlList.add(this.getLogSql());
            this.parameters.clear();
        }
        ((PreparedStatement)this.nativeObject).addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
        ((PreparedStatement)this.nativeObject).clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = ((PreparedStatement)this.nativeObject).execute();
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(this.getLogSql(), start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        long start = System.currentTimeMillis();
        try {
            ResultSet rs = ((PreparedStatement)this.nativeObject).executeQuery();
            if (rs == null) {
                ResultSet resultSet = null;
                return resultSet;
            }
            ResultSet resultSet = this.getResultSet(rs, this);
            return resultSet;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(this.getLogSql(), start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        long start = System.currentTimeMillis();
        try {
            int n = ((PreparedStatement)this.nativeObject).executeUpdate();
            return n;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(this.getLogSql(), start, end);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.nativeObject).getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.nativeObject).getParameterMetaData();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.parameters.set(parameterIndex - 1, x.toString());
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setStringParameter(parameterIndex - 1, x.toString());
    }

    private void setStringParameter(int parameterIndex, String value) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
        } else {
            this.parameters.set(parameterIndex, "'" + value + "'");
        }
    }

    private void setStringParameter(int parameterIndex, String value, int length) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
        } else {
            this.parameters.set(parameterIndex, "'" + value.substring(0, length) + "'");
        }
    }

    private void setNStringParameter(int parameterIndex, String value) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
        } else {
            this.parameters.set(parameterIndex, "N'" + value + "'");
        }
    }

    private void setNStringParameter(int parameterIndex, String value, int length) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
        } else {
            this.parameters.set(parameterIndex, "N'" + value.substring(0, length) + "'");
        }
    }

    private void setBinaryParameter(int parameterIndex, String value) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
        } else {
            this.parameters.set(parameterIndex, "'" + value + "'");
        }
    }

    private void setObjectParameter(int parameterIndex, Object value) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
        } else if (value instanceof Number) {
            this.parameters.set(parameterIndex, value);
        } else {
            this.setStringParameter(parameterIndex, value.toString());
        }
    }

    private void setObjectParameter(int parameterIndex, Object value, int targetSqlType) {
        if (value == null) {
            this.parameters.set(parameterIndex, "null");
            return;
        }
        DataType type = DataType.valueOf(parameterIndex);
        if (type.isNumeric()) {
            this.parameters.set(parameterIndex, value);
        } else if (type.isNationalCharacter()) {
            this.setNStringParameter(parameterIndex, value.toString());
        } else {
            this.setStringParameter(parameterIndex, value.toString());
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null, length);
            } else {
                this.setStringParameter(parameterIndex - 1, x.toString(), length);
            }
        }
        ((PreparedStatement)this.nativeObject).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null, (int)length);
            } else {
                this.setStringParameter(parameterIndex - 1, x.toString(), (int)length);
            }
        }
        ((PreparedStatement)this.nativeObject).setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.parameters.set(parameterIndex - 1, null);
            } else {
                this.parameters.set(parameterIndex - 1, x.toPlainString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (inputStream == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, inputStream.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (inputStream == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, inputStream.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, "byte[]");
            }
        }
        ((PreparedStatement)this.nativeObject).setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, reader.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, reader.toString(), length);
            }
        }
        ((PreparedStatement)this.nativeObject).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, reader.toString(), (int)length);
            }
        }
        ((PreparedStatement)this.nativeObject).setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setClob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, reader.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, reader.toString(), (int)length);
            }
        }
        ((PreparedStatement)this.nativeObject).setClob(parameterIndex, reader, length);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, DateUtils.format(x));
            }
        }
        ((PreparedStatement)this.nativeObject).setDate(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, DateUtils.format(x));
            }
        }
        ((PreparedStatement)this.nativeObject).setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, Float.valueOf(x));
        }
        ((PreparedStatement)this.nativeObject).setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setLong(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (value == null) {
                this.setNStringParameter(parameterIndex - 1, null);
            } else {
                this.setNStringParameter(parameterIndex - 1, value.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (value == null) {
                this.setNStringParameter(parameterIndex - 1, null);
            } else {
                this.setNStringParameter(parameterIndex - 1, value.toString(), (int)length);
            }
        }
        ((PreparedStatement)this.nativeObject).setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (value == null) {
                this.setNStringParameter(parameterIndex - 1, null);
            } else {
                this.setNStringParameter(parameterIndex - 1, value.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setNStringParameter(parameterIndex - 1, null);
            } else {
                this.setNStringParameter(parameterIndex - 1, reader.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setNClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (reader == null) {
                this.setNStringParameter(parameterIndex - 1, null);
            } else {
                this.setNStringParameter(parameterIndex - 1, reader.toString(), (int)length);
            }
        }
        ((PreparedStatement)this.nativeObject).setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.setNStringParameter(parameterIndex - 1, value);
        }
        ((PreparedStatement)this.nativeObject).setNString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, null);
        }
        ((PreparedStatement)this.nativeObject).setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, "CAST(NULL AS " + typeName + ")");
        }
        ((PreparedStatement)this.nativeObject).setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.setObjectParameter(parameterIndex - 1, x);
        }
        try {
            ((PreparedStatement)this.nativeObject).setObject(parameterIndex, x);
        }
        catch (SQLException e) {
            this.error(e.getMessage() + ",object=" + x, e);
            throw e;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.setObjectParameter(parameterIndex - 1, x, targetSqlType);
        }
        ((PreparedStatement)this.nativeObject).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.setObjectParameter(parameterIndex - 1, x, targetSqlType);
        }
        ((PreparedStatement)this.nativeObject).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setRef(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setBinaryParameter(parameterIndex - 1, null);
            } else {
                this.setBinaryParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setRowId(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (xmlObject == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, xmlObject.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.parameters.set(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.setStringParameter(parameterIndex - 1, x);
        }
        ((PreparedStatement)this.nativeObject).setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, DateUtils.format(x));
            }
        }
        ((PreparedStatement)this.nativeObject).setTime(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, DateUtils.format(x));
            }
        }
        ((PreparedStatement)this.nativeObject).setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setStringParameter(parameterIndex - 1, null);
            } else {
                this.setStringParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setURL(parameterIndex, x);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.isSqlLogEnabled()) {
            if (x == null) {
                this.setNStringParameter(parameterIndex - 1, null);
            } else {
                this.setNStringParameter(parameterIndex - 1, x.toString());
            }
        }
        ((PreparedStatement)this.nativeObject).setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((PreparedStatement)this.nativeObject).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((PreparedStatement)this.nativeObject).isCloseOnCompletion();
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        ((PreparedStatement)this.nativeObject).setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        ((PreparedStatement)this.nativeObject).setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return ((PreparedStatement)this.nativeObject).executeLargeUpdate();
    }
}

