/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.jdbc.AbstractConnection;
import com.sqlapp.jdbc.AbstractJdbc;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.apache.logging.log4j.ThreadContext;

public abstract class AbstractStatement<T extends Statement>
extends AbstractJdbc<T>
implements Statement {
    protected final Connection connection;
    private final List<String> batchSqlList = CommonUtils.list();

    public AbstractStatement(T nativeObject, Connection connection) {
        super(nativeObject);
        this.connection = connection;
    }

    protected String formatSql(String sql) {
        return sql.trim();
    }

    protected void logSql(String sql, long start, long end) {
        if (this.isSqlLogEnabled()) {
            ThreadContext.put((String)"process_time", (String)("" + (end - start)));
            com.sqlapp.thread.ThreadContext.setSql(sql);
            String formated = this.formatSql(sql);
            this.info(formated);
        }
    }

    @Override
    protected void logBefore() {
        if (this.connection instanceof AbstractConnection) {
            ThreadContext.put((String)"dialect", (String)((AbstractConnection)this.connection).getDialect().toString());
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.batchSqlList.add(sql);
        }
        ((Statement)this.nativeObject).addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        ((Statement)this.nativeObject).cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.isSqlLogEnabled()) {
            this.batchSqlList.clear();
        }
        ((Statement)this.nativeObject).clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        ((Statement)this.nativeObject).cancel();
    }

    @Override
    public void close() throws SQLException {
        ((Statement)this.nativeObject).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = ((Statement)this.nativeObject).execute(sql);
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = ((Statement)this.nativeObject).execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = ((Statement)this.nativeObject).execute(sql, columnIndexes);
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            boolean bl = ((Statement)this.nativeObject).execute(sql, columnNames);
            return bl;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        long start = System.currentTimeMillis();
        try {
            int[] nArray = ((Statement)this.nativeObject).executeBatch();
            return nArray;
        }
        finally {
            long end = System.currentTimeMillis();
            if (this.isSqlLogEnabled()) {
                int size = this.batchSqlList.size();
                this.logSql("=====START BATCH=====", start, end);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < size; ++i) {
                    builder.append(this.batchSqlList.get(i));
                    builder.append(';');
                    builder.append('\n');
                }
                this.logSql(builder.toString(), start, end);
                this.logSql("=====END BATCH=====", start, end);
                this.batchSqlList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            ResultSet rs = ((Statement)this.nativeObject).executeQuery(sql);
            if (rs == null) {
                ResultSet resultSet = null;
                return resultSet;
            }
            ResultSet resultSet = this.getResultSet(rs, this);
            return resultSet;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    protected abstract ResultSet getResultSet(ResultSet var1, Statement var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            int n = ((Statement)this.nativeObject).executeUpdate(sql);
            return n;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            int n = ((Statement)this.nativeObject).executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            int n = ((Statement)this.nativeObject).executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            int n = ((Statement)this.nativeObject).executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            long end = System.currentTimeMillis();
            this.logSql(sql, start, end);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ((Statement)this.nativeObject).getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return ((Statement)this.nativeObject).getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return ((Statement)this.nativeObject).getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        ResultSet rs = ((Statement)this.nativeObject).getGeneratedKeys();
        if (rs == null) {
            return null;
        }
        return this.getResultSet(rs, this);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return ((Statement)this.nativeObject).getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return ((Statement)this.nativeObject).getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return ((Statement)this.nativeObject).getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return ((Statement)this.nativeObject).getMoreResults(current);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return ((Statement)this.nativeObject).getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet rs = ((Statement)this.nativeObject).getResultSet();
        if (rs == null) {
            return null;
        }
        return this.getResultSet(rs, this);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return ((Statement)this.nativeObject).getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return ((Statement)this.nativeObject).getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return ((Statement)this.nativeObject).getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return ((Statement)this.nativeObject).getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return ((Statement)this.nativeObject).getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return ((Statement)this.nativeObject).isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return ((Statement)this.nativeObject).isPoolable();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        ((Statement)this.nativeObject).setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        ((Statement)this.nativeObject).setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        ((Statement)this.nativeObject).setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        ((Statement)this.nativeObject).setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        ((Statement)this.nativeObject).setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        ((Statement)this.nativeObject).setMaxRows(max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        ((Statement)this.nativeObject).setPoolable(poolable);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        ((Statement)this.nativeObject).setQueryTimeout(seconds);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((Statement)this.nativeObject).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((Statement)this.nativeObject).isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((Statement)this.nativeObject).getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        ((Statement)this.nativeObject).setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((Statement)this.nativeObject).getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return ((Statement)this.nativeObject).executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return ((Statement)this.nativeObject).executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return ((Statement)this.nativeObject).executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return ((Statement)this.nativeObject).executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return ((Statement)this.nativeObject).executeLargeUpdate(sql, columnNames);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return ((Statement)this.nativeObject).enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return ((Statement)this.nativeObject).enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return ((Statement)this.nativeObject).isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return ((Statement)this.nativeObject).enquoteNCharLiteral(val);
    }
}

