/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.jdbc.ConnectionHandler;
import com.sqlapp.jdbc.DataSourceConnectionUtils;
import com.sqlapp.jdbc.GetConnectionHandler;
import com.sqlapp.jdbc.ReleaseConnectionHandler;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceConnectionHandler
implements ConnectionHandler {
    private GetConnectionHandler getConnectionHandler;
    private ReleaseConnectionHandler releaseConnectionHandler;
    private DataSource dataSource;

    public DataSourceConnectionHandler() {
    }

    public DataSourceConnectionHandler(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.getConnectionHandler = () -> DataSourceConnectionUtils.get(dataSource);
        this.releaseConnectionHandler = conn -> DataSourceConnectionUtils.release(dataSource, conn);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnectionHandler.getConnection();
    }

    @Override
    public void releaseConnection(Connection connection) throws SQLException {
        this.releaseConnectionHandler.releaseConnection(connection);
    }
}

