/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.util.DbUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public final class DataSourceConnectionUtils {
    private static final DataSourceConnectionUtils DEFAULT_INSTANCE = new DataSourceConnectionUtils();
    private static GetConnection getConnection = ds -> ds.getConnection();
    private static ReleaseConnection releaseConnection = (ds, conn) -> DbUtils.close(conn);

    public static DataSourceConnectionUtils getInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Connection get(DataSource dataSource) throws SQLException {
        return getConnection.getConnection(dataSource);
    }

    public static void release(DataSource dataSource, Connection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        releaseConnection.releaseConnection(dataSource, connection);
    }

    public static void setGetConnection(GetConnection getConnection) {
        DataSourceConnectionUtils.getConnection = getConnection;
    }

    public static void setReleaseConnection(ReleaseConnection releaseConnection) {
        DataSourceConnectionUtils.releaseConnection = releaseConnection;
    }

    @FunctionalInterface
    public static interface ReleaseConnection {
        public void releaseConnection(DataSource var1, Connection var2) throws SQLException;
    }

    @FunctionalInterface
    public static interface GetConnection {
        public Connection getConnection(DataSource var1) throws SQLException;
    }
}

