/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc;

import com.sqlapp.jdbc.AbstractConnection;
import com.sqlapp.jdbc.SqlappCallableStatement;
import com.sqlapp.jdbc.SqlappPreparedStatement;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SqlappConnection
extends AbstractConnection {
    public SqlappConnection(Connection nativeConnection) {
        super(nativeConnection);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            SqlappPreparedStatement stmt = new SqlappPreparedStatement(((Connection)this.nativeObject).prepareStatement(sql), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    protected void logSql(String sql, SQLException e) {
        if (this.isErrorEnabled()) {
            this.error(sql, e);
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            SqlappPreparedStatement stmt = new SqlappPreparedStatement(((Connection)this.nativeObject).prepareStatement(sql, autoGeneratedKeys), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            SqlappPreparedStatement stmt = new SqlappPreparedStatement(((Connection)this.nativeObject).prepareStatement(sql, columnIndexes), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            SqlappPreparedStatement stmt = new SqlappPreparedStatement(((Connection)this.nativeObject).prepareStatement(sql, columnNames), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            SqlappPreparedStatement stmt = new SqlappPreparedStatement(((Connection)this.nativeObject).prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            SqlappPreparedStatement stmt = new SqlappPreparedStatement(((Connection)this.nativeObject).prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            SqlappCallableStatement stmt = new SqlappCallableStatement(((Connection)this.nativeObject).prepareCall(sql), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            SqlappCallableStatement stmt = new SqlappCallableStatement(((Connection)this.nativeObject).prepareCall(sql, resultSetType, resultSetConcurrency), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            SqlappCallableStatement stmt = new SqlappCallableStatement(((Connection)this.nativeObject).prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this);
            this.initializeChild(stmt);
            return stmt;
        }
        catch (SQLException e) {
            this.logSql(sql, e);
            throw e;
        }
    }

    @Override
    public void setDebug(boolean debug) {
        super.setDebug(debug);
    }
}

