/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.jdbc.sql.ParameterDirection;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;

public final class BindParameter
implements Serializable,
Cloneable,
Comparable<BindParameter> {
    private static final long serialVersionUID = 802393409053455937L;
    private String name = null;
    private String bindingName = null;
    private DataType type = null;
    private Object value = null;
    private int ordinal = 0;
    private ParameterDirection direction = ParameterDirection.Input;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBindingName() {
        return this.bindingName;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public ParameterDirection getDirection() {
        return this.direction;
    }

    public void setDirection(ParameterDirection direction) {
        this.direction = direction;
    }

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder();
        builder.add("name", this.name);
        builder.add("bindingName", this.bindingName);
        builder.add("type", (Object)this.type);
        builder.add("ordinal", this.ordinal);
        builder.add("direction", (Object)this.direction);
        builder.add("value", this.value);
        return builder.toString();
    }

    public BindParameter clone() {
        BindParameter clone = new BindParameter();
        clone.setBindingName(this.bindingName);
        clone.setDirection(this.direction);
        clone.setType(this.type);
        clone.setName(this.name);
        clone.setOrdinal(this.ordinal);
        return clone;
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.name, this.bindingName, (Object)this.type, this.ordinal, (Object)this.direction, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BindParameter)) {
            return false;
        }
        BindParameter val = (BindParameter)obj;
        if (!CommonUtils.eq(this.name, val.name)) {
            return false;
        }
        if (!CommonUtils.eq(this.bindingName, val.bindingName)) {
            return false;
        }
        if (!CommonUtils.eq((Object)this.direction, (Object)val.direction)) {
            return false;
        }
        if (!CommonUtils.eq((Object)this.type, (Object)val.type)) {
            return false;
        }
        if (!CommonUtils.eq(this.ordinal, val.ordinal)) {
            return false;
        }
        return CommonUtils.eq(this.value, val.value);
    }

    @Override
    public int compareTo(BindParameter o) {
        int comp = CommonUtils.compare(this.ordinal, o.ordinal);
        if (comp != 0) {
            return comp;
        }
        return CommonUtils.compare(this.value, o.value);
    }
}

