/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.jdbc.sql.SqlRegistry;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class CachedSqlRegistry
implements SqlRegistry {
    private ConcurrentMap<String, ConcurrentMap<String, List<SqlNode>>> dialectSqlIdMap = CommonUtils.concurrentMap();
    private ConcurrentMap<String, List<SqlNode>> sqlIdMap = CommonUtils.concurrentMap();
    private SqlRegistry sqlRegistry = null;

    public CachedSqlRegistry(SqlRegistry sqlRegistry) {
        this.sqlRegistry = sqlRegistry;
    }

    public SqlRegistry getSqlRegistry() {
        return this.sqlRegistry;
    }

    public void setSqlRegistry(SqlRegistry sqlRegistry) {
        this.sqlRegistry = sqlRegistry;
    }

    public void gcCache() {
        Set<String> removeTarget = CommonUtils.set();
        for (Map.Entry entry : this.sqlIdMap.entrySet()) {
            if (this.contains((String)entry.getKey())) continue;
            removeTarget.add((String)entry.getKey());
        }
        for (String key : removeTarget) {
            this.sqlIdMap.remove(key);
        }
        DoubleKeyMap<String, String, List> doubleKeyMap = new DoubleKeyMap<String, String, List>();
        for (Map.Entry entry : this.dialectSqlIdMap.entrySet()) {
            for (Map.Entry sqlEntry : ((ConcurrentMap)entry.getValue()).entrySet()) {
                if (this.contains((String)entry.getKey(), (String)sqlEntry.getKey())) continue;
                doubleKeyMap.put((String)entry.getKey(), (String)sqlEntry.getKey(), (List)sqlEntry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : doubleKeyMap.entrySet()) {
            for (Map.Entry sqlEntry : ((Map)entry.getValue()).entrySet()) {
                ConcurrentMap map = (ConcurrentMap)this.dialectSqlIdMap.get(entry.getKey());
                if (map == null) continue;
                map.remove(sqlEntry.getKey());
            }
        }
        removeTarget.clear();
        for (Map.Entry<Object, Object> entry : this.dialectSqlIdMap.entrySet()) {
            if (!((ConcurrentMap)entry.getValue()).isEmpty()) continue;
            removeTarget.add((String)entry.getKey());
        }
        for (String string : removeTarget) {
            this.dialectSqlIdMap.remove(string);
        }
    }

    @Override
    public List<SqlNode> getAll(String sqlId, Dialect dialect) {
        List<SqlNode> nodes;
        ConcurrentMap org;
        String databaseProductName = this.getProductName(dialect);
        ConcurrentMap sqlIdMap = this.sqlIdMap;
        if (databaseProductName == null) {
            List<SqlNode> nodes2 = (List<SqlNode>)sqlIdMap.get(sqlId);
            if (CommonUtils.isEmpty(nodes2)) {
                nodes2 = this.getSqlRegistry().getAll(sqlId);
                if (CommonUtils.isEmpty(nodes2)) {
                    List<SqlNode> org2 = sqlIdMap.putIfAbsent(sqlId, nodes2);
                    return org2 != null ? org2 : nodes2;
                }
                return null;
            }
            return nodes2;
        }
        sqlIdMap = (ConcurrentMap)this.dialectSqlIdMap.get(databaseProductName);
        if (sqlIdMap == null && (org = this.dialectSqlIdMap.putIfAbsent(databaseProductName, sqlIdMap = CommonUtils.concurrentMap())) != null) {
            sqlIdMap = org;
        }
        if (CommonUtils.isEmpty(nodes = (List<SqlNode>)sqlIdMap.get(sqlId))) {
            nodes = this.getSqlRegistry().getAll(sqlId, dialect);
            if (CommonUtils.isEmpty(nodes)) {
                List<SqlNode> org3 = sqlIdMap.putIfAbsent(sqlId, nodes);
                return org3 != null ? org3 : nodes;
            }
            return null;
        }
        return nodes;
    }

    @Override
    public List<SqlNode> getAll(String sqlId) {
        return this.getAll(sqlId, null);
    }

    @Override
    public SqlNode get(String sqlId, Dialect dialect) {
        return CommonUtils.first(this.getAll(sqlId, dialect));
    }

    @Override
    public SqlNode get(String sqlId) {
        return CommonUtils.first(this.getAll(sqlId));
    }

    @Override
    public void put(String sqlId, Dialect dialect, String ... sql) {
        this.getSqlRegistry().put(sqlId, dialect, sql);
        String databaseProductName = this.getProductName(dialect);
        ConcurrentMap<String, List<SqlNode>> sqlIdMap = this.sqlIdMap;
        if (databaseProductName == null) {
            sqlIdMap.remove(sqlId);
        } else {
            sqlIdMap = (ConcurrentMap<String, List<SqlNode>>)this.dialectSqlIdMap.get(databaseProductName);
            if (sqlIdMap == null) {
                sqlIdMap = this.sqlIdMap;
            }
            if (sqlIdMap != null) {
                sqlIdMap.remove(sqlId);
            }
        }
    }

    @Override
    public void put(String sqlId, Dialect dialect, String sql) {
        this.put(sqlId, dialect, new String[]{sql});
    }

    @Override
    public void put(String sqlId, String ... sql) {
        this.put(sqlId, (Dialect)null, sql);
    }

    @Override
    public void put(String sqlId, String sql) {
        this.getSqlRegistry().put(sqlId, sql, null);
        ConcurrentMap<String, List<SqlNode>> sqlIdMap = this.sqlIdMap;
        sqlIdMap.remove(sqlId);
    }

    @Override
    public void remove(String sqlId, Dialect dialect) {
        String databaseProductName = this.getProductName(dialect);
        if (databaseProductName != null) {
            this.getSqlRegistry().remove(sqlId, dialect);
            ConcurrentMap sqlIdMap = (ConcurrentMap)this.dialectSqlIdMap.get(databaseProductName);
            if (sqlIdMap != null) {
                sqlIdMap.remove(sqlId);
            }
        } else {
            this.remove(sqlId);
        }
    }

    @Override
    public void remove(String sqlId) {
        this.getSqlRegistry().remove(sqlId);
        this.sqlIdMap.remove(sqlId);
    }

    protected String getProductName(Dialect dialect) {
        if (dialect == null) {
            return null;
        }
        String databaseProductName = dialect.getProductName();
        return databaseProductName.toLowerCase();
    }

    @Override
    public boolean contains(String sqlId) {
        return this.sqlIdMap.containsKey(sqlId);
    }

    @Override
    public boolean contains(String sqlId, String databaseProductName) {
        ConcurrentMap<String, List<SqlNode>> sqlIdMap = this.sqlIdMap;
        if (databaseProductName == null) {
            return sqlIdMap.containsKey(sqlId);
        }
        sqlIdMap = (ConcurrentMap<String, List<SqlNode>>)this.dialectSqlIdMap.get(databaseProductName);
        if (sqlIdMap == null) {
            sqlIdMap = this.sqlIdMap;
        }
        if (sqlIdMap != null) {
            return sqlIdMap.containsKey(sqlId);
        }
        return false;
    }
}

