/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public interface GeneratedKeyHandler {
    public void handle(long var1, GeneratedKeyInfo var3);

    public static class GeneratedKeyInfo
    implements Serializable {
        private static final long serialVersionUID = 885479078079064921L;
        private final Object catalogName;
        private final Object schemaName;
        private final Object tableName;
        private final Object columnName;
        private final Object columnLabel;
        private final Object value;
        private final int columnNo;
        private final Converters converters;

        protected GeneratedKeyInfo(ResultSetMetaData metaData, ResultSet rs, int columnNo) throws SQLException {
            this.catalogName = metaData.getCatalogName(columnNo);
            this.schemaName = metaData.getSchemaName(columnNo);
            this.tableName = metaData.getTableName(columnNo);
            this.columnName = metaData.getColumnName(columnNo);
            this.columnLabel = metaData.getColumnLabel(columnNo);
            this.value = rs.getObject(columnNo);
            this.columnNo = columnNo - 1;
            this.converters = Converters.getDefault();
        }

        public Object getCatalogName() {
            return this.catalogName;
        }

        public Object getSchemaName() {
            return this.schemaName;
        }

        public Object getTableName() {
            return this.tableName;
        }

        public Object getColumnName() {
            return this.columnName;
        }

        public Object getColumnLabel() {
            return this.columnLabel;
        }

        public Object getValue() {
            return this.value;
        }

        public <T> T getValue(Class<T> clazz) {
            return this.converters.convertObject(this.value, clazz);
        }

        public int getColumnNo() {
            return this.columnNo;
        }

        public String toString() {
            ToStringBuilder builder = new ToStringBuilder();
            builder.add("catalogName", this.catalogName);
            builder.add("schemaName", this.schemaName);
            builder.add("tableName", this.tableName);
            builder.add("columnName", this.columnName);
            builder.add("columnLabel", this.columnLabel);
            builder.add("value", this.value);
            return builder.toString();
        }
    }
}

