/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.converter.EnumConvertable;

public enum ResultSetConcurrency implements EnumConvertable<Integer>
{
    CONCUR_READ_ONLY(1007),
    CONCUR_UPDATABLE(1008);

    private final Integer value;
    private final String text;

    private ResultSetConcurrency(int value) {
        this.value = value;
        this.text = this.name().replace("_", "");
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static ResultSetConcurrency parse(Integer value) {
        for (ResultSetConcurrency type : ResultSetConcurrency.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        return ResultSetConcurrency.getDefault();
    }

    public static ResultSetConcurrency parse(String value) {
        if (value == null) {
            return ResultSetConcurrency.getDefault();
        }
        value = value.replace("_", "");
        for (ResultSetConcurrency type : ResultSetConcurrency.values()) {
            if (type.text.equalsIgnoreCase(value)) {
                return type;
            }
            if (!type.getValue().toString().equals(value)) continue;
            return type;
        }
        return ResultSetConcurrency.getDefault();
    }

    public static ResultSetConcurrency getDefault() {
        return CONCUR_READ_ONLY;
    }
}

