/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.converter.EnumConvertable;

public enum ResultSetHoldability implements EnumConvertable<Integer>
{
    HOLD_CURSORS_OVER_COMMIT(1),
    CLOSE_CURSORS_AT_COMMIT(2);

    private final Integer value;
    private final String text;

    private ResultSetHoldability(int value) {
        this.value = value;
        this.text = this.name().replace("_", "");
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static ResultSetHoldability parse(Integer value) {
        for (ResultSetHoldability type : ResultSetHoldability.values()) {
            if (!type.getValue().equals(value)) continue;
            return type;
        }
        return ResultSetHoldability.getDefault();
    }

    public static ResultSetHoldability parse(String value) {
        if (value == null) {
            return ResultSetHoldability.getDefault();
        }
        value = value.replace("_", "");
        for (ResultSetHoldability type : ResultSetHoldability.values()) {
            if (type.text.equalsIgnoreCase(value)) {
                return type;
            }
            if (!type.getValue().toString().equals(value)) continue;
            return type;
        }
        return ResultSetHoldability.getDefault();
    }

    public static ResultSetHoldability getDefault() {
        return CLOSE_CURSORS_AT_COMMIT;
    }
}

