/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql;

import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.rowiterator.ExpressionConverter;
import com.sqlapp.exceptions.InvalidTextException;
import com.sqlapp.jdbc.sql.SqlParser;
import com.sqlapp.jdbc.sql.node.SqlNode;

public class SqlConverter {
    private ExpressionConverter expressionConverter = new ExpressionConverter();

    public ExpressionConverter getExpressionConverter() {
        return this.expressionConverter;
    }

    public void setExpressionConverter(ExpressionConverter expressionConverter) {
        this.expressionConverter = expressionConverter;
    }

    public SqlNode parseSql(ParametersContext context, String sql) {
        if (this.getExpressionConverter().isPlaceholders()) {
            return this.parseSqlInternal(context, sql);
        }
        return SqlParser.getInstance().parse(sql);
    }

    private SqlNode parseSqlInternal(ParametersContext context, String sql) {
        StringBuilder builder = new StringBuilder(sql.length());
        int pos = 0;
        boolean find = false;
        while (pos < sql.length()) {
            int start = sql.indexOf(this.getExpressionConverter().getPlaceholderPrefix(), pos);
            if (start >= 0) {
                int end = sql.indexOf(this.getExpressionConverter().getPlaceholderSuffix(), start + this.getExpressionConverter().getPlaceholderPrefix().length());
                if (end < 0) {
                    this.toInvalidTextException(sql, pos, "placeholderSuffix[" + this.getExpressionConverter().getPlaceholderSuffix() + "] not found.");
                }
                builder.append(sql.substring(pos, start));
                String expression = sql.substring(start + this.getExpressionConverter().getPlaceholderPrefix().length(), end);
                builder.append("/*" + expression + "*/'1'");
                pos = end + 1;
                find = true;
                continue;
            }
            builder.append(sql.substring(pos));
            break;
        }
        SqlNode node = find ? SqlParser.getInstance().parse(builder.toString()) : SqlParser.getInstance().parse(sql);
        return node;
    }

    private InvalidTextException toInvalidTextException(String sql, int pos, String message) {
        int lineBreakCount = 1;
        int lastLineBreakPos = 0;
        for (int i = 0; i < pos; ++i) {
            if (sql.charAt(i) != '\n') continue;
            ++lineBreakCount;
            lastLineBreakPos = i;
        }
        int nextLineBreakPos = 0;
        for (nextLineBreakPos = pos; nextLineBreakPos < sql.length() && sql.charAt(nextLineBreakPos) != '\n'; ++nextLineBreakPos) {
        }
        throw new InvalidTextException(sql.substring(lastLineBreakPos + 1, nextLineBreakPos), lineBreakCount, pos, message);
    }
}

