/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.jdbc.sql.node.Node;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.Factory;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractNodeFactory<T extends Node>
implements Factory<T> {
    public SortedMap<Integer, T> parseSql(String sql) {
        SortedMap result = CommonUtils.treeMap();
        for (Pattern pattern : this.getMatchPatterns()) {
            SortedMap<Integer, T> map = this.parseSql(pattern, sql);
            for (Map.Entry<Integer, T> entry : map.entrySet()) {
                if (result.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), (Node)entry.getValue());
            }
        }
        return result;
    }

    protected SortedMap<Integer, T> parseSql(Pattern pattern, String sql) {
        SortedMap result = CommonUtils.treeMap();
        Matcher matcher = pattern.matcher(sql);
        while (matcher.find()) {
            boolean reject = false;
            for (Pattern rejectPattern : this.getRejectPatterns()) {
                Matcher rMatcher = rejectPattern.matcher(matcher.group(0));
                if (!rMatcher.matches()) continue;
                reject = true;
                break;
            }
            if (reject) continue;
            int start = matcher.start();
            int end = matcher.end();
            Node node = (Node)this.newInstance();
            node.setIndex(start);
            this.setNodeValue(node, matcher);
            node.setSql(sql.substring(start, end));
            this.initialize(node);
            result.put(node.getIndex(), node);
        }
        return result;
    }

    protected abstract void setNodeValue(T var1, Matcher var2);

    protected abstract Pattern[] getMatchPatterns();

    protected Pattern[] getRejectPatterns() {
        return new Pattern[0];
    }

    protected void initialize(T t) {
    }
}

