/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.jdbc.sql.node;

import com.sqlapp.data.parameter.ParameterDefinition;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.Node;
import com.sqlapp.util.CommonUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentNode
extends Node {
    private static final long serialVersionUID = -2382715829576494053L;
    private String matchText = null;
    protected String expression = null;
    private ParameterDefinition parameterDefinition;
    private static final Pattern SQL_PATTERN = Pattern.compile("(SELECT|INSERT|UPDATE|DELETE|DROP|TRUNCATE|UNION|TABLE)", 10);

    @Override
    public boolean eval(Object context, SqlParameterCollection sqlParameters) {
        return true;
    }

    public String getMatchText() {
        return this.matchText;
    }

    public void setMatchText(String matchText) {
        this.matchText = matchText;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = CommonUtils.trim(expression);
    }

    @Override
    public String toString() {
        return this.getMatchText();
    }

    protected static String sanitize(String text) {
        if (text == null) {
            return text;
        }
        if (text.charAt(0) == '\'' && text.charAt(text.length() - 1) == '\'') {
            return "'" + CommentNode.sanitizeInternal(text.substring(1, text.length() - 1)) + "'";
        }
        return CommentNode.sanitizeInternal(text);
    }

    protected static String sanitizeInternal(String text) {
        if (text == null) {
            return text;
        }
        return text.replace("'", "''").replace("/*", "").replace("*/", "").replace("--", "").replace(";", "");
    }

    protected void setParameterDefinition(ParameterDefinition parameterDefinition) {
        this.parameterDefinition = parameterDefinition != null && parameterDefinition.getName() == null ? null : parameterDefinition;
    }

    public ParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    protected boolean containsSqlWord(String text) {
        Matcher matcher = SQL_PATTERN.matcher(text);
        return matcher.find();
    }
}

