/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.thread;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Map;

public class ThreadContext
implements Serializable {
    private static final long serialVersionUID = 7286837483883803285L;
    private static ObjectHandler objectHandler = new ObjectHandler();
    private static StringParameterHandler stringParameterHandler = new StringParameterHandler();
    private static final ThreadLocal<Map<Object, Object>> THREAD_LOCAL_OBJECT_MAP = new ThreadLocal<Map<Object, Object>>(){

        @Override
        protected Map<Object, Object> initialValue() {
            return CommonUtils.map();
        }
    };

    public static void init() {
        ThreadContext.release();
        THREAD_LOCAL_OBJECT_MAP.remove();
    }

    public static void init(Map mdcContext, Map<Object, Object> context) {
        ThreadContext.release();
        if (mdcContext != null) {
            for (Map.Entry entry : mdcContext.entrySet()) {
                org.apache.logging.log4j.ThreadContext.put((String)entry.getKey().toString(), (String)entry.getValue().toString());
            }
        }
        THREAD_LOCAL_OBJECT_MAP.remove();
        if (context != null) {
            THREAD_LOCAL_OBJECT_MAP.get().putAll(context);
        }
    }

    public static void release() {
        THREAD_LOCAL_OBJECT_MAP.remove();
        org.apache.logging.log4j.ThreadContext.clearAll();
    }

    public static Map getMdcContext() {
        return org.apache.logging.log4j.ThreadContext.getContext();
    }

    public void setMDC(String key, String value) {
        org.apache.logging.log4j.ThreadContext.put((String)key, (String)value);
    }

    public static String getMDC(String key) {
        return org.apache.logging.log4j.ThreadContext.get((String)key);
    }

    public static Map<Object, Object> getContext() {
        return THREAD_LOCAL_OBJECT_MAP.get();
    }

    public static void setObject(Object value) {
        objectHandler.setObject(value);
    }

    public static void removeObject(Object key) {
        objectHandler.removeObject(key);
    }

    public static void setObject(Object key, Object value) {
        objectHandler.setObject(key, value);
    }

    public static <T> T getObject(Class<T> clazz) {
        return objectHandler.getObject(clazz);
    }

    public static <T> T getObject(Object key) {
        return objectHandler.getObject(key);
    }

    public static void setSql(String sql) {
        ThreadContext.set("sql", sql);
    }

    public static String getSql() {
        return ThreadContext.get("sql");
    }

    protected static void set(String attribute, String value) {
        ThreadContext.getStringParameterHandler().set(attribute, value);
    }

    protected static String get(String attribute) {
        return ThreadContext.getStringParameterHandler().get(attribute);
    }

    public static void setSqlProcessTime(Long sqlProcessTime) {
        if (sqlProcessTime != null) {
            ThreadContext.set("sqlProcessTime", "" + sqlProcessTime);
        } else {
            ThreadContext.set("sqlProcessTime", null);
        }
    }

    public static Long getSqlProcessTime() {
        return Converters.getDefault().convertObject(ThreadContext.get("sqlProcessTime"), Long.class);
    }

    public static void setObjectHandler(ObjectHandler objectHandler) {
        ThreadContext.objectHandler = objectHandler;
    }

    public static ObjectHandler getObjectHandler() {
        return objectHandler;
    }

    public static StringParameterHandler getStringParameterHandler() {
        return stringParameterHandler;
    }

    public static void setStringParameterHandler(StringParameterHandler stringParameterHandler) {
        ThreadContext.stringParameterHandler = stringParameterHandler;
    }

    public static class ObjectHandler {
        public <T> T getObject(Class<T> clazz) {
            return clazz.cast(ThreadContext.getContext().get(clazz));
        }

        public <T> T getObject(Object key) {
            return (T)ThreadContext.getContext().get(key);
        }

        public void setObject(Object value) {
            if (value == null) {
                return;
            }
            ThreadContext.getContext().put(value.getClass(), value);
        }

        public void setObject(Object key, Object value) {
            ThreadContext.getContext().put(key, value);
        }

        public void removeObject(Object key) {
            ThreadContext.getContext().remove(key);
        }
    }

    public static class StringParameterHandler {
        public String get(String key) {
            return org.apache.logging.log4j.ThreadContext.get((String)key);
        }

        public void set(String key, String value) {
            if (value == null) {
                org.apache.logging.log4j.ThreadContext.remove((String)key);
            } else {
                org.apache.logging.log4j.ThreadContext.put((String)key, (String)value);
            }
        }
    }
}

