/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.EvalExecutor;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public abstract class AbstractIterator<T> {
    private int step = 0;
    private boolean callLastStep = true;
    private String expression = null;
    private CachedEvaluator evaluator = null;

    public AbstractIterator() {
    }

    public AbstractIterator(int step) {
        this.step = step;
    }

    public AbstractIterator(int step, boolean callLastStep) {
        this.step = step;
        this.callLastStep = callLastStep;
    }

    public AbstractIterator(CachedEvaluator evaluator, String expression) {
        this.evaluator = evaluator;
        this.expression = expression;
    }

    public AbstractIterator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public AbstractIterator(CachedEvaluator evaluator, String expression, int step, boolean callLastStep) {
        this.evaluator = evaluator;
        this.expression = expression;
        this.step = step;
        this.callLastStep = callLastStep;
    }

    public AbstractIterator<T> execute(Object val) throws Exception {
        try {
            this.doExecute(val);
            AbstractIterator abstractIterator = this;
            return abstractIterator;
        }
        finally {
            this.executeFinally();
        }
    }

    public AbstractIterator<T> execute(List<?> list) throws Exception {
        try {
            this.iterateList(list);
            AbstractIterator abstractIterator = this;
            return abstractIterator;
        }
        finally {
            this.executeFinally();
        }
    }

    public AbstractIterator<T> execute(Iterable<?> iterable) throws Exception {
        try {
            this.iterateCollection(iterable);
            AbstractIterator abstractIterator = this;
            return abstractIterator;
        }
        finally {
            this.executeFinally();
        }
    }

    public AbstractIterator<T> execute(Enumeration<?> enumeration) throws Exception {
        try {
            this.iterateEnumeration(enumeration);
            AbstractIterator abstractIterator = this;
            return abstractIterator;
        }
        finally {
            this.executeFinally();
        }
    }

    protected void doExecute(Object val) throws Exception {
        if (val == null) {
            return;
        }
        if (val instanceof List) {
            List list = (List)val;
            this.iterateList(list);
        } else if (val instanceof Iterable) {
            Iterable c = (Iterable)val;
            this.execute(c);
        } else if (val instanceof Enumeration) {
            Enumeration c = (Enumeration)val;
            this.execute(c);
        } else if (val instanceof Map) {
            Map c = (Map)val;
            this.execute(c.entrySet());
        } else if (val.getClass().isArray()) {
            Class<?> compClass = val.getClass().getComponentType();
            if (compClass.isPrimitive()) {
                this.iterateArray(val);
            } else {
                Object[] arr = (Object[])val;
                this.iterateArray(arr);
            }
        } else {
            this.handle(this.eval(val), 0);
        }
    }

    private T eval(Object val) {
        if (this.evaluator != null && this.expression != null) {
            return this.eval(this.evaluator.getEvalExecutor(this.expression), val);
        }
        return (T)val;
    }

    private T eval(EvalExecutor evalExecutor, Object val) {
        if (val == null) {
            return null;
        }
        Object con = Converters.getDefault().getConverter(val.getClass());
        if (con == null) {
            return (T)evalExecutor.eval(val);
        }
        return (T)val;
    }

    protected void handleException(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    protected void executeFinally() {
    }

    protected void iterateList(List<?> list) throws Exception {
        int length = list.size();
        for (int i = 0; i < length; ++i) {
            Object val = list.get(i);
            this.handle(this.eval(val), i);
            this.callStepHandle(i);
        }
        this.callStepLast(length);
    }

    protected void iterateCollection(Iterable<?> args) throws Exception {
        int i = 0;
        for (Object val : args) {
            this.handle(this.eval(val), i);
            this.callStepHandle(i);
            ++i;
        }
        this.callStepLast(i);
    }

    protected void iterateEnumeration(Enumeration<?> args) throws Exception {
        int i = 0;
        while (args.hasMoreElements()) {
            this.handle(this.eval(args.nextElement()), i);
            this.callStepHandle(i);
            ++i;
        }
        this.callStepLast(i);
    }

    protected long iterateArray(Object[] arr) throws Exception {
        long count = 0L;
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            this.handle(this.eval(arr[i]), i);
            this.callStepHandle(i);
        }
        this.callStepLast(length);
        return count;
    }

    protected long iterateArray(Object arr) throws Exception {
        long count = 0L;
        int length = Array.getLength(arr);
        for (int i = 0; i < length; ++i) {
            this.handle(this.eval(Array.get(arr, i)), i);
            this.callStepHandle(i);
        }
        this.callStepLast(length);
        return count;
    }

    protected void callStepHandle(int i) throws Exception {
        if (this.step == 0 || (i + 1) % this.step != 0) {
            return;
        }
        this.stepHandle(i / this.step, this.step);
    }

    protected void callStepLast(int length) throws Exception {
        if (this.step == 0 || !this.callLastStep) {
            return;
        }
        if (length % this.step == 0) {
            return;
        }
        this.stepHandle(length / this.step, length % this.step);
    }

    protected abstract void handle(T var1, int var2) throws Exception;

    protected void stepHandle(int index, int stepSize) throws Exception {
    }
}

