/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractJarHandler<T, S> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ClassLoader classLoader;
    private final Predicate<S> filter;
    private Method getNextEntryMethod = null;

    public AbstractJarHandler(ClassLoader classLoader, Predicate<S> filter) {
        this.classLoader = classLoader;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> search(String rootPackageName, URL url, boolean recursive) {
        InputStream stream;
        List classes;
        block17: {
            URLConnection connection;
            classes = CommonUtils.list();
            try {
                connection = url.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JarURLConnection juconnection = null;
            if (connection instanceof JarURLConnection) {
                juconnection = (JarURLConnection)connection;
            }
            stream = null;
            try {
                String packageNameAsResourceName = this.packageNameToResourceName(rootPackageName);
                if (juconnection != null) {
                    JarFile jarFile = null;
                    try {
                        jarFile = juconnection.getJarFile();
                        Enumeration<JarEntry> enm = jarFile.entries();
                        while (enm.hasMoreElements()) {
                            JarEntry jarEntry = enm.nextElement();
                            if (jarEntry.isDirectory()) continue;
                            try {
                                this.handleJarEntry(jarEntry, packageNameAsResourceName, recursive, classes);
                            }
                            catch (ClassNotFoundException e) {
                                this.logger.warn(e.getMessage(), (Throwable)e);
                            }
                        }
                        break block17;
                    }
                    finally {
                        FileUtils.close(jarFile);
                    }
                }
                stream = connection.getInputStream();
                JarEntry jarEntry = null;
                while ((jarEntry = this.getNextJarEntry(stream)) != null) {
                    if (jarEntry.isDirectory()) continue;
                    try {
                        this.handleJarEntry(jarEntry, packageNameAsResourceName, recursive, classes);
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    FileUtils.close(stream);
                    throw throwable;
                }
            }
        }
        FileUtils.close(stream);
        return classes;
    }

    private String packageNameToResourceName(String packageName) {
        return packageName.replace('.', '/');
    }

    protected JarEntry getNextJarEntry(Object obj) {
        if (this.getNextEntryMethod == null) {
            try {
                this.getNextEntryMethod = obj.getClass().getMethod("getNextJarEntry", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (JarEntry)this.getNextEntryMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean equalsPackage(JarEntry jarEntry, String packageNameAsResourceName) {
        String name = jarEntry.getName();
        if (name.length() > packageNameAsResourceName.length() + 1) {
            if (!name.startsWith(packageNameAsResourceName)) {
                return false;
            }
            return !(name = name.substring(packageNameAsResourceName.length() + 1)).contains("/");
        }
        return false;
    }

    public Predicate<S> getFilter() {
        return this.filter;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected abstract void handleJarEntry(JarEntry var1, String var2, boolean var3, List<T> var4) throws ClassNotFoundException;
}

