/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Base64;
import java.util.UUID;

public final class BinaryUtils {
    private static final int BUFFER_LENGTH = 4096;

    private BinaryUtils() {
    }

    public static byte[] toBinary(Object o) {
        byte[] byArray;
        ObjectOutputStream ostream = null;
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(4096);
        try {
            ostream = new ObjectOutputStream(bstream);
            ostream.writeObject(o);
            byArray = bstream.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(ostream);
                throw throwable;
            }
        }
        FileUtils.close(ostream);
        return byArray;
    }

    public static Object toObject(byte[] binary) {
        return BinaryUtils.toObject(new ByteArrayInputStream(binary));
    }

    public static Object toObject(InputStream stream) {
        Object object;
        ObjectInputStream ostream = null;
        try {
            ostream = new ObjectInputStream(stream);
            object = ostream.readObject();
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                FileUtils.close(ostream);
                throw throwable;
            }
        }
        FileUtils.close(ostream);
        return object;
    }

    public static byte[] decodeBase64(String value) {
        return Base64.getMimeDecoder().decode(value);
    }

    public static byte[] decodeBase64(byte[] value) {
        return Base64.getMimeDecoder().decode(value);
    }

    public static String encodeBase64(byte[] value) {
        return Base64.getMimeEncoder().encodeToString(value);
    }

    public static byte[] toBinary(UUID ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(UUID key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(InputStream is) {
        byte[] byArray;
        byte[] bytes = new byte[2048];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while ((len = is.read(bytes)) != -1) {
                bos.write(bytes, 0, len);
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bos.close();
        return byArray;
    }

    public static byte[] toBinary(ByteOrder order, UUID uuid) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(16);
        keyBuffer.order(order);
        keyBuffer.putLong(uuid.getMostSignificantBits());
        keyBuffer.putLong(uuid.getLeastSignificantBits());
        return keyBuffer.array();
    }

    public static byte[] toBinary(ByteOrder order, UUID ... key) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(16 * key.length);
        keyBuffer.order(order);
        for (UUID uuid : key) {
            keyBuffer.putLong(uuid.getMostSignificantBits());
            keyBuffer.putLong(uuid.getLeastSignificantBits());
        }
        return keyBuffer.array();
    }

    public static UUID[] toUUIDArray(byte[] bytes) {
        return BinaryUtils.toUUIDArray(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static UUID[] toUUIDArray(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        int size = keyBuffer.limit() / 16;
        UUID[] result = new UUID[size];
        for (int i = 0; i < size; ++i) {
            UUID uuid;
            result[i] = uuid = new UUID(keyBuffer.getLong(i * 16), keyBuffer.getLong(i * 16 + 8));
        }
        return result;
    }

    public static UUID toUUID(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        UUID result = new UUID(keyBuffer.getLong(0), keyBuffer.getLong(8));
        return result;
    }

    public static UUID toUUID(byte[] bytes) {
        return BinaryUtils.toUUID(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static byte[] toBinary(short key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(short ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(Short ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(ByteOrder order, short key) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(2);
        keyBuffer.order(order);
        keyBuffer.putShort(key);
        return keyBuffer.array();
    }

    public static byte[] toBinary(ByteOrder order, short ... key) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(2 * key.length);
        keyBuffer.order(order);
        for (short val : key) {
            keyBuffer.putShort(val);
        }
        return keyBuffer.array();
    }

    public static byte[] toBinary(ByteOrder order, Short ... key) {
        return BinaryUtils.toBinary(order, CommonUtils.toShortArray(key));
    }

    public static short toShort(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        return keyBuffer.getShort(0);
    }

    public static short toShort(byte[] bytes) {
        return BinaryUtils.toShort(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static short[] toShortArray(byte[] bytes) {
        return BinaryUtils.toShortArray(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static short[] toShortArray(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        int size = keyBuffer.limit() / 2;
        short[] result = new short[size];
        for (int i = 0; i < size; ++i) {
            result[i] = keyBuffer.getShort(i * 2);
        }
        return result;
    }

    public static byte[] toBinary(int ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(Integer ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(ByteOrder order, int val) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(4);
        keyBuffer.order(order);
        keyBuffer.putInt(val);
        return keyBuffer.array();
    }

    public static byte[] toBinary(ByteOrder order, int ... key) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(4 * key.length);
        keyBuffer.order(order);
        for (int val : key) {
            keyBuffer.putInt(val);
        }
        return keyBuffer.array();
    }

    public static byte[] toBinary(ByteOrder order, Integer ... key) {
        return BinaryUtils.toBinary(order, CommonUtils.toIntArray(key));
    }

    public static int[] toIntArray(byte[] bytes) {
        return BinaryUtils.toIntArray(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static int toInt(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        return keyBuffer.getInt(0);
    }

    public static int toInt(byte[] bytes) {
        return BinaryUtils.toInt(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static int[] toIntArray(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        int size = keyBuffer.limit() / 4;
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = keyBuffer.getInt(i * 4);
        }
        return result;
    }

    public static byte[] toBinary(int key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(long key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(long ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(Long ... key) {
        return BinaryUtils.toBinary(ByteOrder.BIG_ENDIAN, key);
    }

    public static byte[] toBinary(ByteOrder order, Long ... key) {
        return BinaryUtils.toBinary(order, CommonUtils.toLongArray(key));
    }

    public static byte[] toBinary(ByteOrder order, long ... key) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(8 * key.length);
        keyBuffer.order(order);
        for (long val : key) {
            keyBuffer.putLong(val);
        }
        return keyBuffer.array();
    }

    public static byte[] toBinary(ByteOrder order, long val) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(8);
        keyBuffer.order(order);
        keyBuffer.putLong(val);
        return keyBuffer.array();
    }

    public static long[] toLongArray(byte[] bytes) {
        return BinaryUtils.toLongArray(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static long[] toLongArray(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        int size = keyBuffer.limit() / 8;
        long[] result = new long[size];
        for (int i = 0; i < size; ++i) {
            result[i] = keyBuffer.getLong(i * 8);
        }
        return result;
    }

    public static long toLong(ByteOrder order, byte[] bytes) {
        ByteBuffer keyBuffer = ByteBuffer.allocate(bytes.length);
        keyBuffer.order(order);
        keyBuffer.put(bytes);
        return keyBuffer.getLong(0);
    }

    public static long toLong(byte[] bytes) {
        return BinaryUtils.toLong(ByteOrder.BIG_ENDIAN, bytes);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(bytes.length * 2);
        for (int index = 0; index < bytes.length; ++index) {
            int bt = bytes[index] & 0xFF;
            builder.append(Character.forDigit(bt >> 4 & 0xF, 16));
            builder.append(Character.forDigit(bt & 0xF, 16));
        }
        return builder.toString();
    }

    public static byte[] toBinaryFromHex(String hex) {
        byte[] bytes = new byte[hex.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(hex.substring(i * 2, (i + 1) * 2), 16);
        }
        return bytes;
    }
}

