/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveMap<T>
implements Map<String, T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1946073595454206975L;
    protected Map<String, T> map = null;
    protected Map<String, String> keyMap = null;

    public CaseInsensitiveMap() {
        this.map = CommonUtils.map();
        this.keyMap = CommonUtils.upperMap();
    }

    public CaseInsensitiveMap(int size) {
        this.map = CommonUtils.map(size);
        this.keyMap = CommonUtils.upperMap(size);
    }

    public CaseInsensitiveMap(Map<String, T> baseMap) {
        this.map = baseMap;
        this.keyMap = CommonUtils.upperMap(baseMap.size());
    }

    @Override
    public T put(String key, T value) {
        if (!this.keyMap.containsKey(key)) {
            this.keyMap.put(key, key);
        }
        return this.map.put(this.keyMap.get(key), value);
    }

    @Override
    public void clear() {
        this.map.clear();
        this.keyMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public T get(Object key) {
        if (key == null) {
            return this.get(null);
        }
        return this.get(key.toString());
    }

    public T get(String key) {
        T obj = this.map.get(key);
        if (obj != null) {
            return obj;
        }
        String innerKey = this.keyMap.get(key);
        if (innerKey == null) {
            return null;
        }
        return this.map.get(innerKey);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public T remove(Object key) {
        T ret;
        String originalKey = this.keyMap.get(key);
        if (originalKey != null) {
            ret = this.map.remove(originalKey);
            this.keyMap.remove(originalKey);
        } else {
            ret = this.map.remove(key);
        }
        return ret;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<T> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> m) {
        for (Map.Entry<String, T> entry : m.entrySet()) {
            String key = entry.getKey();
            T value = entry.getValue();
            this.put(key, value);
        }
    }

    public CaseInsensitiveMap<T> clone() {
        CaseInsensitiveMap<T> clone = new CaseInsensitiveMap<T>(CommonUtils.cloneMap(this.map));
        return clone;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CaseInsensitiveMap)) {
            return false;
        }
        CaseInsensitiveMap cst = (CaseInsensitiveMap)obj;
        return CommonUtils.eq(this.map, cst.map);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }
}

