/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import java.io.IOException;
import java.io.OutputStream;

public class CompositeOutputStream
extends OutputStream {
    private OutputStream[] outputStreams;

    protected CompositeOutputStream() {
    }

    public CompositeOutputStream(OutputStream ... outputStreams) {
        this.outputStreams = outputStreams;
    }

    protected void setOutputStreams(OutputStream[] outputStreams) {
        this.outputStreams = outputStreams;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int size = this.outputStreams.length;
        IOException ioe = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.outputStreams[i].write(b, off, len);
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void write(int b) throws IOException {
        int size = this.outputStreams.length;
        for (int i = 0; i < size; ++i) {
            this.outputStreams[i].write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        int size = this.outputStreams.length;
        IOException ioe = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.outputStreams[i].flush();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    @Override
    public void close() throws IOException {
        int size = this.outputStreams.length;
        IOException ioe = null;
        for (int i = 0; i < size; ++i) {
            try {
                this.outputStreams[i].close();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

