/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public final class DateUtils {
    private static final ThreadLocal<Map<String, DateFormat>> threadLocalDateFormat = new ThreadLocal<Map<String, DateFormat>>(){

        @Override
        protected Map<String, DateFormat> initialValue() {
            return CommonUtils.map();
        }
    };
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";

    private DateUtils() {
    }

    public static Date currentDate() {
        return DateUtils.truncateTime(DateUtils.currentDateTime());
    }

    public static Date currentDateTime() {
        return new Date();
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(DateUtils.currentDateTime().getTime());
    }

    public static Time currentTime() {
        return DateUtils.toTime(DateUtils.currentDateTime());
    }

    public static Date truncateMilisecond(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime() / 1000L * 1000L);
    }

    public static Calendar truncateMilisecond(Calendar cal) {
        cal.set(14, 0);
        return cal;
    }

    public static Date truncateTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.truncateTime(DateUtils.toCalendar(date)).getTime();
    }

    public static Calendar truncateTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public static Timestamp truncateTime(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(ts);
        return new Timestamp(DateUtils.toDate(DateUtils.truncateTime(cal)).getTime());
    }

    public static Timestamp truncateMilisecond(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return new Timestamp(DateUtils.truncateMilisecond(DateUtils.toCalendar(ts)).getTime().getTime());
    }

    public static Calendar addSeconds(Calendar date, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)date.clone();
        cal.add(13, seconds);
        return cal;
    }

    public static Time addSeconds(Time time, int seconds) {
        if (time == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(time);
        cal.add(13, seconds);
        return DateUtils.toTime(cal.getTime());
    }

    public static Date addSeconds(Date date, int seconds) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(13, seconds);
        return cal.getTime();
    }

    public static Calendar addMinutes(Calendar date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)date.clone();
        cal.add(12, minutes);
        return cal;
    }

    public static Time addMinutes(Time time, int minutes) {
        if (time == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(time);
        cal.add(12, minutes);
        return DateUtils.toTime(cal.getTime());
    }

    public static Date addMinutes(Date date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(12, minutes);
        return cal.getTime();
    }

    public static Calendar addHours(Calendar date, int hours) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)date.clone();
        cal.add(11, hours);
        return cal;
    }

    public static Time addHours(Time time, int hours) {
        if (time == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(time);
        cal.add(11, hours);
        return DateUtils.toTime(cal.getTime());
    }

    public static Date addHours(Date date, int hours) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(11, hours);
        return cal.getTime();
    }

    public static Calendar addDays(Calendar date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)date.clone();
        cal.add(5, days);
        return cal;
    }

    public static Date addDays(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(5, days);
        return cal.getTime();
    }

    public static java.sql.Date addDays(java.sql.Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(5, days);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Date addMonths(Date date, int months) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(2, months);
        return cal.getTime();
    }

    public static Calendar addMonths(Calendar date, int months) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)date.clone();
        cal.add(2, months);
        return cal;
    }

    public static java.sql.Date addMonths(java.sql.Date date, int months) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(2, months);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Calendar addYears(Calendar date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = (Calendar)date.clone();
        cal.add(1, days);
        return cal;
    }

    public static java.sql.Date addYears(java.sql.Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(1, years);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Date addYears(Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.add(1, years);
        return cal.getTime();
    }

    public static Timestamp addSeconds(Timestamp ts, int seconds) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.add(13, seconds);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(nanos);
        return result;
    }

    public static Timestamp addMinutes(Timestamp ts, int minutes) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.add(12, minutes);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(nanos);
        return result;
    }

    public static Timestamp addHours(Timestamp ts, int hours) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.add(11, hours);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(nanos);
        return result;
    }

    public static Timestamp addDays(Timestamp ts, int days) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.add(5, days);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(nanos);
        return result;
    }

    public static Timestamp addMonths(Timestamp ts, int months) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.add(2, months);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(nanos);
        return result;
    }

    public static Date addYears(Timestamp ts, int years) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.add(1, years);
        Timestamp result = new Timestamp(cal.getTimeInMillis());
        result.setNanos(nanos);
        return result;
    }

    public static Date setDate(Date date, int dt) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(5, dt);
        return cal.getTime();
    }

    public static java.sql.Date setDate(java.sql.Date date, int dt) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(5, dt);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Timestamp setDate(Timestamp ts, int dt) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.set(5, dt);
        Timestamp result = new Timestamp(cal.getTime().getTime());
        result.setNanos(nanos);
        return result;
    }

    public static Date setMonth(Date date, int month) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(2, month);
        return cal.getTime();
    }

    public static java.sql.Date setMonth(java.sql.Date date, int month) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(2, month);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Timestamp setMonth(Timestamp ts, int month) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.set(2, month);
        Timestamp result = new Timestamp(cal.getTime().getTime());
        result.setNanos(nanos);
        return result;
    }

    public static Date setYear(Date date, int year) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(1, year);
        return cal.getTime();
    }

    public static java.sql.Date setYear(java.sql.Date date, int year) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(1, year);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Timestamp setYear(Timestamp ts, int year) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.set(1, year);
        Timestamp result = new Timestamp(cal.getTime().getTime());
        result.setNanos(nanos);
        return result;
    }

    public static Calendar toCalendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Calendar toCalendar(long timeInMills) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMills);
        return cal;
    }

    public static Time toTime(Calendar cal) {
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        Time t = new Time(cal.getTimeInMillis());
        return t;
    }

    public static Time toTime(Date date) {
        if (date == null) {
            return null;
        }
        return DateUtils.toTime(DateUtils.toCalendar(date));
    }

    public static Time toTime(long timeInMillis) {
        Time t = new Time(timeInMillis);
        return t;
    }

    public static java.sql.Date toSqlDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static java.sql.Date toSqlDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(DateUtils.truncateTime(date).getTime());
    }

    public static java.sql.Date toSqlDate(String value, String format) throws ParseException {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        return DateUtils.toSqlDate(DateUtils.parse(value, format));
    }

    public static Date toDate(Timestamp ts) {
        if (ts == null) {
            return null;
        }
        return new Date(ts.getTime());
    }

    public static Date toDate(Calendar cal) {
        if (cal == null) {
            return null;
        }
        return cal.getTime();
    }

    public static Date toDate(long timeInMills) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMills);
        return cal.getTime();
    }

    public static Date toDate(String value, String format) throws ParseException {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        return DateUtils.parse(value, format);
    }

    public static Time toTime(String value) throws ParseException {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        return DateUtils.toTime(DateUtils.parse(value, DEFAULT_TIME_FORMAT));
    }

    public static Time toTime(String value, String format) throws ParseException {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        if (CommonUtils.isEmpty(format)) {
            return DateUtils.toTime(DateUtils.parse(value));
        }
        return DateUtils.toTime(DateUtils.parse(value, format));
    }

    public static java.sql.Date toSqlDate(long timeInMills) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timeInMills);
        return DateUtils.toSqlDate(cal);
    }

    public static Timestamp toTimestamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Timestamp toTimestamp(Calendar date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTimeInMillis());
    }

    public static Timestamp toTimestamp(long timeInMills) {
        return new Timestamp(timeInMills);
    }

    public static Timestamp toTimestamp(String value, String format) throws ParseException {
        if (CommonUtils.isEmpty(value)) {
            return null;
        }
        return new Timestamp(DateUtils.parse(value, format).getTime());
    }

    public static Date sunday(Date date) {
        return DateUtils.addDays(DateUtils.monday(date), -1);
    }

    public static Timestamp sunday(Timestamp date) {
        return DateUtils.addDays(DateUtils.monday(date), -1);
    }

    public static Calendar sunday(Calendar date) {
        return DateUtils.addDays(DateUtils.monday(date), -1);
    }

    public static Date monday(Date date) {
        return DateUtils.setWeek(date, 2);
    }

    public static Timestamp monday(Timestamp date) {
        return DateUtils.setWeek(date, 2);
    }

    public static Date beginningOfMonth(Date date) {
        return DateUtils.setDate(date, 1);
    }

    public static Timestamp beginningOfMonth(Timestamp date) {
        return DateUtils.setDate(date, 1);
    }

    public static Calendar beginningOfMonth(Calendar date) {
        date.set(5, 1);
        return date;
    }

    public static Date beginningOfYear(Date date) {
        return DateUtils.setMonth(DateUtils.setDate(date, 1), 0);
    }

    public static Timestamp beginningOfYear(Timestamp date) {
        return DateUtils.setMonth(DateUtils.setDate(date, 1), 0);
    }

    public static Calendar beginningOfYear(Calendar date) {
        date.set(5, 1);
        date.set(2, 0);
        return date;
    }

    public static Date beginningOfQuarter(Date date, int accountingPeriod) {
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(2, accountingPeriod);
        cal.set(5, 1);
        cal = DateUtils.truncateTime(cal);
        Date acStartDate = DateUtils.toDate(cal);
        if (acStartDate.compareTo(date) == 0) {
            return date;
        }
        if (acStartDate.compareTo(date) < 0) {
            cal.add(1, 1);
            acStartDate = DateUtils.toDate(cal);
        }
        for (int i = 0; i < 8; ++i) {
            acStartDate = DateUtils.toDate(cal);
            if (cal.getTime().compareTo(date) <= 0) {
                return cal.getTime();
            }
            cal.add(2, -3);
        }
        return null;
    }

    public static Timestamp beginningOfQuarter(Timestamp date, int accountingPeriod) {
        return DateUtils.toTimestamp(DateUtils.beginningOfQuarter((Date)date, accountingPeriod));
    }

    public static Calendar beginningOfQuarter(Calendar date, int accountingPeriod) {
        Calendar cal = (Calendar)date.clone();
        cal.set(2, accountingPeriod);
        cal.set(5, 1);
        cal = DateUtils.truncateTime(cal);
        if (cal.getTime().compareTo(date.getTime()) == 0) {
            return date;
        }
        if (cal.getTime().compareTo(date.getTime()) < 0) {
            cal.add(1, 1);
        }
        for (int i = 0; i < 8; ++i) {
            if (cal.getTime().compareTo(date.getTime()) <= 0) {
                return cal;
            }
            cal.add(2, -3);
        }
        return null;
    }

    public static Timestamp setWeek(Timestamp ts, int week) {
        if (ts == null) {
            return null;
        }
        int nanos = ts.getNanos();
        Calendar cal = DateUtils.toCalendar(ts);
        cal.set(7, week);
        Timestamp result = new Timestamp(cal.getTime().getTime());
        result.setNanos(nanos);
        return result;
    }

    public static Date setWeek(Date date, int week) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(7, week);
        return cal.getTime();
    }

    public static java.sql.Date setWeek(java.sql.Date date, int week) {
        if (date == null) {
            return null;
        }
        Calendar cal = DateUtils.toCalendar(date);
        cal.set(7, week);
        return DateUtils.toSqlDate(cal.getTime());
    }

    public static Calendar monday(Calendar date) {
        date.set(7, 2);
        return date;
    }

    public static String format(Date date, String format) {
        DateFormat dateFormat = DateUtils.getDateFormat(format);
        return dateFormat.format(date);
    }

    public static String format(Calendar date, String format) {
        DateFormat dateFormat = DateUtils.getDateFormat(format);
        return dateFormat.format(date);
    }

    public static Date parse(String dateString, String format) throws ParseException {
        DateFormat dateFormat = DateUtils.getDateFormat(format);
        return dateFormat.parse(dateString);
    }

    public static Date parse(String dateString) throws ParseException {
        if (CommonUtils.isEmpty(dateString)) {
            return null;
        }
        if (dateString.length() < 15) {
            return DateUtils.parse(dateString, DEFAULT_DATE_FORMAT);
        }
        return DateUtils.parse(dateString, DEFAULT_DATETIME_FORMAT);
    }

    private static DateFormat getDateFormat(String format) {
        Map<String, DateFormat> map = threadLocalDateFormat.get();
        DateFormat dateFormat = map.get(format);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(format);
            map.put(format, dateFormat);
        }
        return dateFormat;
    }

    public static String format(Date date) {
        return DateUtils.format(date, DEFAULT_DATETIME_FORMAT);
    }

    public static String format(Calendar date) {
        return DateUtils.format(date, DEFAULT_DATETIME_FORMAT);
    }

    public static String format(Time date) {
        return DateUtils.format(date, DEFAULT_TIME_FORMAT);
    }

    public static final void clear() {
        threadLocalDateFormat.remove();
    }
}

