/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.util.CommonUtils;
import difflib.ChangeDelta;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.InsertDelta;

public class DeltaUtils {
    public static String toStringLine(Delta<?> delta) {
        if (delta == null) {
            return "";
        }
        return DeltaUtils.toStringLineNumber(delta, 0);
    }

    public static String toStringLineNumber(Delta<?> delta, int size) {
        int pos;
        if (delta == null) {
            return "";
        }
        StringBuilder builder = DeltaUtils.getBuilder2(delta);
        int scale = DeltaUtils.scale(size);
        String zero = CommonUtils.getString('0', scale);
        boolean first = true;
        if (delta instanceof DeleteDelta || delta instanceof ChangeDelta) {
            pos = delta.getOriginal().getPosition() + 1;
            for (Object obj : delta.getOriginal().getLines()) {
                if (!first) {
                    builder.append("\n");
                }
                first = false;
                builder.append("-");
                builder.append(CommonUtils.right(zero + pos++, scale));
                builder.append(":");
                builder.append(obj);
            }
        }
        if (delta instanceof InsertDelta || delta instanceof ChangeDelta) {
            pos = delta.getRevised().getPosition() + 1;
            for (Object obj : delta.getRevised().getLines()) {
                if (!first) {
                    builder.append("\n");
                }
                first = false;
                builder.append("+");
                builder.append(CommonUtils.right(zero + pos++, scale));
                builder.append(":");
                if (obj instanceof DbCommonObject) {
                    builder.append(((DbCommonObject)obj).toStringSimple());
                    continue;
                }
                builder.append(obj);
            }
        }
        return builder.toString();
    }

    private static int scale(int size) {
        if ((size = Math.abs(size)) == 0) {
            return 0;
        }
        int ret = (int)Math.log10(size) + 1;
        if (ret < 3) {
            return 3;
        }
        return ret;
    }

    private static StringBuilder getBuilder2(Delta<?> delta) {
        StringBuilder builder = new StringBuilder(256);
        return builder;
    }

    public static String toString(Delta<?> delta) {
        if (delta == null) {
            return "";
        }
        StringBuilder builder = DeltaUtils.getBuilder(delta);
        if (delta instanceof DeleteDelta || delta instanceof ChangeDelta) {
            for (Object obj : delta.getOriginal().getLines()) {
                builder.append("\n");
                builder.append("-");
                builder.append(obj);
            }
        }
        if (delta instanceof InsertDelta || delta instanceof ChangeDelta) {
            for (Object obj : delta.getRevised().getLines()) {
                builder.append("\n");
                builder.append("+");
                builder.append(obj);
            }
        }
        return builder.toString();
    }

    private static StringBuilder getBuilder(Delta<?> delta) {
        StringBuilder builder = new StringBuilder(256);
        builder.append("@@ -");
        builder.append(delta.getOriginal().getPosition());
        builder.append(",");
        builder.append(delta.getOriginal().last());
        builder.append(" +");
        builder.append(delta.getRevised().getPosition());
        builder.append(",");
        builder.append(delta.getRevised().last());
        builder.append(" @@");
        return builder;
    }
}

