/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class DoubleKeyMap<S, T, U>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<S, Map<T, U>> innerMap = CommonUtils.linkedMap();

    public U get(S key1, T key2) {
        Map<T, U> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.get(key2);
    }

    public Map<T, U> get(S key1) {
        return CommonUtils.linkedMap(this.innerMap.get(key1));
    }

    public U remove(S key1, T key2) {
        Map<T, U> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.remove(key2);
    }

    public Set<S> keySet() {
        return this.innerMap.keySet();
    }

    public Set<T> secondKeySet() {
        Set result = CommonUtils.linkedSet();
        for (Map.Entry<S, Map<T, U>> entry : this.entrySet()) {
            result.addAll(entry.getValue().keySet());
        }
        return result;
    }

    public Set<Map.Entry<S, Map<T, U>>> entrySet() {
        return this.innerMap.entrySet();
    }

    public void put(S key1, T key2, U value) {
        Map<Object, Object> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            map2 = CommonUtils.linkedMap();
            this.innerMap.put(key1, map2);
        }
        map2.put(key2, value);
    }

    public boolean containsKey(S key1, T key2) {
        Map<T, U> map2 = this.innerMap.get(key1);
        if (map2 != null) {
            return map2.containsKey(key2);
        }
        return false;
    }

    public void clear() {
        this.innerMap.clear();
    }

    public void clear(S key1) {
        Map<T, U> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return;
        }
        map2.clear();
    }

    public List<U> toList() {
        List list = CommonUtils.list();
        for (Map.Entry<S, Map<T, U>> entry : this.entrySet()) {
            for (Map.Entry<T, U> entry1 : entry.getValue().entrySet()) {
                list.add(entry1.getValue());
            }
        }
        return list;
    }

    public Map<S, List<U>> toMapList() {
        Map map = CommonUtils.map();
        for (Map.Entry<S, Map<T, U>> entry : this.entrySet()) {
            List list = CommonUtils.list();
            for (Map.Entry<T, U> entry1 : entry.getValue().entrySet()) {
                list.add(entry1.getValue());
            }
            map.put(entry.getKey(), list);
        }
        return map;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<S, Map<T, U>> entry : this.entrySet()) {
            for (Map.Entry<T, U> entry1 : entry.getValue().entrySet()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("{");
                builder.append("(");
                builder.append(entry.getKey());
                builder.append(", ");
                builder.append(entry1.getKey());
                builder.append(")=");
                builder.append(entry1.getValue());
                builder.append("}");
                first = false;
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public int size() {
        int ret = 0;
        for (Map.Entry<S, Map<T, U>> entry : this.innerMap.entrySet()) {
            ret += entry.getValue().size();
        }
        return ret;
    }

    public DoubleKeyMap<S, T, U> clone() {
        DoubleKeyMap<S, T, U> clone = new DoubleKeyMap<S, T, U>();
        clone.innerMap = CommonUtils.linkedMap(this.innerMap);
        return clone;
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.innerMap);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DoubleKeyMap)) {
            return false;
        }
        DoubleKeyMap cst = (DoubleKeyMap)obj;
        return this.innerMap.equals(cst.innerMap);
    }

    public static <U, S, T> DoubleKeyMap<S, T, U> toMap(Collection<U> c, Function<U, S> func1, Function<U, T> func2) {
        if (c == null) {
            return CommonUtils.doubleKeyMap();
        }
        DoubleKeyMap result = new DoubleKeyMap();
        c.forEach(v -> {
            Object key1 = func1.apply(v);
            Object key2 = func2.apply(v);
            result.put(key1, key2, v);
        });
        return result;
    }

    public static <S, T, U> DoubleKeyMap<S, T, List<U>> toListMap(Collection<U> c, Function<U, S> func1, Function<U, T> func2) {
        if (c == null) {
            return CommonUtils.doubleKeyMap();
        }
        DoubleKeyMap result = new DoubleKeyMap();
        c.forEach(v -> {
            Object key2;
            Object key1 = func1.apply(v);
            List list = (List)result.get(key1, key2 = func2.apply(v));
            if (list == null) {
                list = CommonUtils.list();
                result.put(key1, key2, list);
            }
            list.add(v);
        });
        return result;
    }
}

