/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import java.util.Arrays;
import java.util.function.BooleanSupplier;

public class EqualsUtils {
    private static final BooleanSupplier TRUE_SUPPLIER = new TrueSupplier();
    private static final BooleanSupplier FALSE_SUPPLIER = new FalseSupplier();

    public static BooleanSupplier getEqualsSupplier(Object o1, Object o2) {
        return new CachedEqualsSupplier<Object>(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(Object[] o1, Object[] o2) {
        return new ObjectArraySupplier(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(String[] o1, String[] o2) {
        return new StringArraySupplier(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(String o1, String o2) {
        return new CachedEqualsSupplier<String>(o1, o2);
    }

    public static BooleanSupplier getEqualsIgnoreCaseSupplier(String o1, String o2) {
        return new EqualsIgnoreCaseSupplier(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(Integer o1, Integer o2) {
        return new CachedEqualsSupplier<Integer>(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(short o1, short o2) {
        if (o1 == o2) {
            return TRUE_SUPPLIER;
        }
        return FALSE_SUPPLIER;
    }

    public static BooleanSupplier getEqualsSupplier(int o1, int o2) {
        if (o1 == o2) {
            return TRUE_SUPPLIER;
        }
        return FALSE_SUPPLIER;
    }

    public static BooleanSupplier getEqualsSupplier(long o1, long o2) {
        if (o1 == o2) {
            return TRUE_SUPPLIER;
        }
        return FALSE_SUPPLIER;
    }

    public static BooleanSupplier getEqualsSupplier(boolean o1, boolean o2) {
        if (o1 == o2) {
            return TRUE_SUPPLIER;
        }
        return FALSE_SUPPLIER;
    }

    public static BooleanSupplier getEqualsSupplier(byte[] o1, byte[] o2) {
        return new ByteArraySupplier(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(Boolean o1, Boolean o2) {
        return new CachedEqualsSupplier<Boolean>(o1, o2);
    }

    public static BooleanSupplier getEqualsSupplier(boolean bool) {
        if (bool) {
            return TRUE_SUPPLIER;
        }
        return FALSE_SUPPLIER;
    }

    public static BooleanSupplier getEqualsSupplier(BooleanSupplier booleanSupplier) {
        return booleanSupplier;
    }

    private static class EqualsIgnoreCaseSupplier
    extends CachedEqualsSupplier<String> {
        public EqualsIgnoreCaseSupplier(String o1, String o2) {
            super(o1, o2);
        }

        @Override
        protected boolean test(String t, String u) {
            return CommonUtils.eqIgnoreCase((String)this.o1, (String)this.o2);
        }
    }

    private static class StringArraySupplier
    extends CachedEqualsSupplier<String[]> {
        public StringArraySupplier(String[] o1, String[] o2) {
            super(o1, o2);
        }

        @Override
        protected boolean test(String[] t, String[] u) {
            return Arrays.deepEquals(t, u);
        }
    }

    private static class ObjectArraySupplier
    extends CachedEqualsSupplier<Object[]> {
        public ObjectArraySupplier(Object[] o1, Object[] o2) {
            super(o1, o2);
        }

        @Override
        protected boolean test(Object[] t, Object[] u) {
            return Arrays.deepEquals(t, u);
        }
    }

    private static class ByteArraySupplier
    extends CachedEqualsSupplier<byte[]> {
        public ByteArraySupplier(byte[] o1, byte[] o2) {
            super(o1, o2);
        }

        @Override
        protected boolean test(byte[] t, byte[] u) {
            return CommonUtils.eq(t, u);
        }
    }

    private static class CachedEqualsSupplier<T>
    extends SimpleEqualsSupplier<T> {
        private boolean evaluated = false;
        private boolean value = false;

        public CachedEqualsSupplier(T o1, T o2) {
            super(o1, o2);
        }

        @Override
        public boolean getAsBoolean() {
            if (this.evaluated) {
                return this.value;
            }
            this.value = this.test(this.o1, this.o2);
            this.evaluated = true;
            return this.value;
        }
    }

    private static class SimpleEqualsSupplier<T>
    implements BooleanSupplier {
        protected final T o1;
        protected final T o2;

        public SimpleEqualsSupplier(T o1, T o2) {
            this.o1 = o1;
            this.o2 = o2;
        }

        protected boolean test(T t, T u) {
            if (t == u) {
                return true;
            }
            if (t != null && u != null) {
                return t.equals(u);
            }
            return false;
        }

        @Override
        public boolean getAsBoolean() {
            return this.test(this.o1, this.o2);
        }
    }

    private static class FalseSupplier
    implements BooleanSupplier {
        private FalseSupplier() {
        }

        @Override
        public boolean getAsBoolean() {
            return false;
        }
    }

    private static class TrueSupplier
    implements BooleanSupplier {
        private TrueSupplier() {
        }

        @Override
        public boolean getAsBoolean() {
            return true;
        }
    }
}

