/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractResourceSearcher;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.ResourceFinder;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;

public class FileResourceSearcher
extends AbstractResourceSearcher {
    private static final String[] PROTOCOLS = new String[]{"file"};

    @Override
    public <T> List<ResourceFinder.ResourceInfo> search(String packageName, URL url, boolean recursive) {
        File file = new File(this.getPath(url));
        return this.searchInternal(packageName, file, recursive);
    }

    protected <T> List<ResourceFinder.ResourceInfo> searchInternal(String packageName, File file, boolean recursive) {
        List<ResourceFinder.ResourceInfo> results = CommonUtils.list();
        if (file.isFile()) {
            if (!this.isResourceFile(file.getAbsolutePath())) {
                return results;
            }
            ResourceFinder.ResourceInfo resourceInfo = new ResourceFinder.ResourceInfo(file.toURI(), this.getClassLoader(), packageName, file.getName());
            if (this.getFilter().test(resourceInfo)) {
                results.add(resourceInfo);
            }
            return results;
        }
        String[] pathes = file.list();
        if (pathes == null) {
            return results;
        }
        for (String path : pathes) {
            File entry = new File(file, path);
            if (entry.isFile()) {
                if (!this.isResourceFile(entry.getName())) continue;
                ResourceFinder.ResourceInfo resourceInfo = new ResourceFinder.ResourceInfo(entry.toURI(), this.getClassLoader(), packageName, entry.getName());
                if (!this.getFilter().test(resourceInfo)) continue;
                results.add(resourceInfo);
                continue;
            }
            if (!recursive) continue;
            results.addAll(this.searchInternal(packageName + "." + entry.getName(), entry, recursive));
        }
        return results;
    }

    private String getPath(URL url) {
        String file = url.getFile();
        try {
            return URLDecoder.decode(file, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String[] supportProtocols() {
        return PROTOCOLS;
    }
}

