/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StringUtils;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class OutputTextBuilder {
    private StringBuilder builder = new StringBuilder();
    private String indentString = "\t";
    private int indentLevel = 0;
    private String lineSeparator = "=";
    private Converters converters = Converters.getDefault();

    public OutputTextBuilder append(Object val) {
        this.appendInternal(val);
        return this.instance();
    }

    public OutputTextBuilder append(Table table) {
        return this.append(table, (Column a, Row b) -> b.get((Column)a));
    }

    public OutputTextBuilder append(Table table, Predicate<Column> p) {
        return this.append(table, p, (a, b) -> b.get((Column)a));
    }

    public OutputTextBuilder append(Table table, BiFunction<Column, Row, Object> bifunc) {
        return this.append(table, c -> true, bifunc);
    }

    public OutputTextBuilder append(Table table, Predicate<Column> p, BiFunction<Column, Row, Object> bifunc) {
        List columns = CommonUtils.list();
        for (int i = 0; i < table.getColumns().size(); ++i) {
            Column column = (Column)table.getColumns().get(i);
            if (!p.test(column)) continue;
            columns.add(column);
        }
        Object[] objects = new Object[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            Column column = (Column)columns.get(i);
            objects[i] = column.getName();
        }
        List<Line> columnLines = this.toLine(objects);
        List<Line> totalRowLines = CommonUtils.list();
        for (Row row : table.getRows()) {
            Object[] values = new Object[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                Column column = (Column)columns.get(i);
                values[i] = bifunc.apply(column, row);
            }
            List<Line> rowLines = this.toLine(values);
            totalRowLines.addAll(rowLines);
        }
        List<Line> totalLines = CommonUtils.list();
        totalLines.addAll(columnLines);
        totalLines.addAll(totalRowLines);
        this.setLineSize(totalLines);
        int len = this.outputLines(columnLines);
        this.lineBreak();
        this.append((Object)this.lineSeparator, len);
        this.lineBreak();
        this.outputLines(totalRowLines);
        return this.instance();
    }

    private int outputLines(List<Line> lines) {
        int len = 0;
        int j = 0;
        for (Line line : lines) {
            this.lineBreak(j > 0);
            len = 0;
            for (int i = 0; i < line.values.length; ++i) {
                String name = line.values[i];
                this.append((Object)" | ", i > 0);
                this.appendFix(name, line.sizes[i]);
                len += line.sizes[i];
                if (i <= 0) continue;
                len += 3;
            }
            ++j;
        }
        return len;
    }

    private List<Line> toLine(Object ... args) {
        String[] texts = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            String[] obj = args[i];
            texts[i] = this.toString(obj);
        }
        int row = 1;
        for (String text : texts) {
            row = Math.max(row, this.row(text));
        }
        List<Line> lines = CommonUtils.list();
        for (int i = 0; i < row; ++i) {
            Line line = new Line();
            lines.add(line);
            line.values = new String[texts.length];
            line.sizes = new int[texts.length];
        }
        String[] empty = new String[row];
        for (int i = 0; i < texts.length; ++i) {
            String text;
            text = texts[i];
            String[] splits = text != null ? text.split("\n") : empty;
            for (int j = 0; j < row; ++j) {
                Line line = lines.get(j);
                if (splits.length <= j) continue;
                line.values[i] = splits[j];
            }
        }
        return lines;
    }

    private void setLineSize(List<Line> lines) {
        if (CommonUtils.isEmpty(lines)) {
            return;
        }
        int length = lines.get((int)0).values.length;
        for (int i = 0; i < length; ++i) {
            int size = 0;
            for (Line line : lines) {
                String text = line.values[i];
                size = Math.max(size, this.length(text));
            }
            for (Line line : lines) {
                line.sizes[i] = size;
            }
        }
    }

    private int length(Object obj) {
        if (obj == null) {
            return 0;
        }
        String val = this.toString(obj);
        String[] args = val.split("\n");
        int len = 0;
        for (String arg : args) {
            len = Math.max(len, this.lengthSimple(arg));
        }
        return len;
    }

    private int row(Object obj) {
        if (obj == null) {
            return 0;
        }
        String val = this.toString(obj);
        String[] args = val.split("\n");
        return args.length;
    }

    private int lengthSimple(String val) {
        return StringUtils.getDisplayWidth(val);
    }

    public OutputTextBuilder appendFix(Object val, int length) {
        return this.appendFix(val, ' ', length);
    }

    public OutputTextBuilder appendFix(Object val, char c, int length) {
        String txt = this.toString(val);
        StringBuilder builder = new StringBuilder(length);
        if (txt != null) {
            builder.append(txt);
        }
        while (StringUtils.getDisplayWidth(builder) < length) {
            builder.append(c);
        }
        this.appendInternal(builder.toString());
        return this.instance();
    }

    public Converters getConverters() {
        return this.converters;
    }

    public void setConverters(Converters converters) {
        this.converters = converters;
    }

    private String toString(Object val) {
        return this.converters.convertString(val);
    }

    public OutputTextBuilder append(Object val, int iterate) {
        for (int i = 0; i < iterate; ++i) {
            this.appendInternal(val);
        }
        return this.instance();
    }

    public OutputTextBuilder append(char val, int iterate) {
        for (int i = 0; i < iterate; ++i) {
            this.appendInternal(val);
        }
        return this.instance();
    }

    public OutputTextBuilder append(char val, boolean bool) {
        if (!bool) {
            return this.instance();
        }
        return this.appendInternal(val);
    }

    public OutputTextBuilder append(Object val, boolean bool) {
        if (!bool) {
            return this.instance();
        }
        return this.appendInternal(val);
    }

    private OutputTextBuilder appendInternal(Object val) {
        if (val == null) {
            return this.instance();
        }
        this.builder.append(this.toString(val));
        return this.instance();
    }

    private OutputTextBuilder appendInternal(char val) {
        this.builder.append(val);
        return this.instance();
    }

    public OutputTextBuilder lineBreak() {
        return this.lineBreak(true);
    }

    public OutputTextBuilder lineBreak(boolean bool) {
        if (bool) {
            this.builder.append("\n");
            this.indent();
        }
        return this.instance();
    }

    private OutputTextBuilder indent() {
        this.append((Object)this.indentString, this.indentLevel);
        return this.instance();
    }

    private OutputTextBuilder instance() {
        return this;
    }

    public String toString() {
        return this.builder.toString();
    }

    static class Line {
        public String[] values = null;
        public int[] sizes = null;

        Line() {
        }
    }
}

