/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.StringUtils;
import java.nio.charset.Charset;

public enum PaddingType {
    LEFT{

        @Override
        public String addPadding(String input, int length, String padding) {
            if (length <= 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder(length);
            int remain = length - input.length();
            while (builder.length() < remain) {
                builder.append(padding);
            }
            builder.append(input);
            return builder.substring(builder.length() - length, builder.length());
        }

        @Override
        public String addPaddingCodePoint(String input, int length, String padding) {
            if (length <= 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder(length);
            int remain = length - input.codePointCount(0, input.length());
            int paddingCodepointLen = padding.codePointCount(0, padding.length());
            for (int len = 0; len < remain; len += paddingCodepointLen) {
                builder.append(padding);
            }
            builder.append(input);
            return builder.substring(builder.length() - length, builder.length());
        }

        @Override
        public String trimPadding(String input, String padding) {
            if (input == null || input.length() == 0) {
                return "";
            }
            int i = 0;
            boolean match = true;
            for (i = 0; i < input.length(); i += padding.length()) {
                for (int j = 0; j < padding.length(); ++j) {
                    if (input.charAt(i + j) == padding.charAt(j)) continue;
                    match = false;
                    break;
                }
                if (!match) break;
            }
            return input.substring(i);
        }

        @Override
        public byte[] addPadding(byte[] input, int length, byte[] padding) {
            if (length <= 0) {
                return EMPTY_BYTES;
            }
            byte[] result = new byte[length];
            int len = input.length > length ? length : input.length;
            1.arraycopy(input, 0, result, length - len, len);
            for (int i = 0; i < length - len; i += padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    result[i + j] = padding[j];
                }
            }
            return result;
        }

        @Override
        public byte[] trimPadding(byte[] input, byte[] padding) {
            if (input == null || input.length == 0) {
                return EMPTY_BYTES;
            }
            if (padding == null || padding.length == 0) {
                return input;
            }
            int len = input.length;
            boolean match = true;
            int currentPosition = 0;
            for (int i = 0; i <= len - padding.length; i += padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    if (input[i + j] == padding[j]) continue;
                    match = false;
                    break;
                }
                if (!match) break;
                currentPosition = i + padding.length;
            }
            byte[] result = new byte[len - currentPosition];
            1.arraycopy(input, currentPosition, result, 0, len - currentPosition);
            return result;
        }

        @Override
        public String toString(byte[] input, int offset, int length, byte[] padding, Charset charset) {
            if (input == null || input.length == 0) {
                return "";
            }
            if (offset >= input.length) {
                return "";
            }
            int len = offset + length > input.length ? input.length : offset + length;
            boolean match = true;
            int currentPosition = offset;
            for (int i = offset; i <= len; i += padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    if (input[i + j] == padding[j]) continue;
                    match = false;
                    break;
                }
                if (!match) break;
                currentPosition = i + padding.length;
            }
            return new String(input, currentPosition, len - currentPosition, charset);
        }

        @Override
        public void setBytes(byte[] input, byte[] padding, int offset, int length, byte[] buffer) {
            int len = offset + length - input.length;
            for (int i = offset; i < len; i += padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    buffer[i + j] = padding[j];
                }
            }
            1.arraycopy(input, 0, buffer, offset + length - input.length, input.length);
        }

        @Override
        public boolean isPrefix() {
            return true;
        }
    }
    ,
    RIGHT{

        @Override
        public String addPadding(String input, int length, String padding) {
            if (length <= 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder(length);
            builder.append(input);
            while (builder.length() < length) {
                builder.append(padding);
            }
            return builder.substring(0, length);
        }

        @Override
        public String addPaddingCodePoint(String input, int length, String padding) {
            if (length <= 0) {
                return "";
            }
            StringBuilder builder = new StringBuilder(length);
            builder.append(input);
            int paddingCodepointLen = padding.codePointCount(0, padding.length());
            for (int len = input.codePointCount(0, input.length()); len < length; len += paddingCodepointLen) {
                builder.append(padding);
            }
            if (builder.codePointCount(0, builder.length()) == length) {
                return builder.toString();
            }
            return StringUtils.substringCodePoint(builder.toString(), 0, length);
        }

        @Override
        public String trimPadding(String input, String padding) {
            if (input == null || input.length() == 0) {
                return "";
            }
            int len = input.length();
            boolean match = true;
            int currentPosition = input.length();
            for (int i = len - padding.length(); i >= 0; i -= padding.length()) {
                for (int j = 0; j < padding.length(); ++j) {
                    if (input.charAt(i + j) == padding.charAt(j)) continue;
                    match = false;
                    break;
                }
                if (!match) break;
                currentPosition = i;
            }
            return input.substring(0, currentPosition);
        }

        @Override
        public byte[] addPadding(byte[] input, int length, byte[] padding) {
            if (length <= 0) {
                return EMPTY_BYTES;
            }
            byte[] result = new byte[length];
            int len = input.length > length ? length : input.length;
            2.arraycopy(input, 0, result, 0, len);
            for (int i = len; i < length; i += padding.length) {
                for (int j = 0; j < padding.length && i + j < length; ++j) {
                    result[i + j] = padding[j];
                }
            }
            return result;
        }

        @Override
        public byte[] trimPadding(byte[] input, byte[] padding) {
            if (input == null || input.length == 0) {
                return EMPTY_BYTES;
            }
            if (padding == null || padding.length == 0) {
                return input;
            }
            int len = input.length;
            boolean match = true;
            int currentPosition = input.length;
            for (int i = len - padding.length; i >= 0; i -= padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    if (input[i + j] == padding[j]) continue;
                    match = false;
                    break;
                }
                if (!match) break;
                currentPosition = i;
            }
            byte[] result = new byte[currentPosition];
            2.arraycopy(input, 0, result, 0, currentPosition);
            return result;
        }

        @Override
        public String toString(byte[] input, int offset, int length, byte[] padding, Charset charset) {
            int start;
            if (input == null || input.length == 0) {
                return "";
            }
            if (offset >= input.length) {
                return "";
            }
            int len = offset + length > input.length ? input.length : length;
            boolean match = true;
            int currentPosition = len;
            for (int i = start = len - padding.length - 1; i >= offset; i -= padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    if (input[i + j] == padding[j]) continue;
                    match = false;
                    break;
                }
                if (!match) break;
                currentPosition = i;
            }
            return new String(input, offset, currentPosition - offset, charset);
        }

        @Override
        public void setBytes(byte[] input, byte[] padding, int offset, int length, byte[] buffer) {
            int start = offset + input.length;
            int len = offset + length - padding.length + 1;
            for (int i = start; i < len; i += padding.length) {
                for (int j = 0; j < padding.length; ++j) {
                    buffer[i + j] = padding[j];
                }
            }
            2.arraycopy(input, 0, buffer, offset, input.length);
        }

        @Override
        public boolean isSuffix() {
            return true;
        }
    }
    ,
    NO_PADDING{

        @Override
        public boolean isNoPadding() {
            return true;
        }
    };

    private static final byte[] EMPTY_BYTES;

    public byte[] addPadding(byte[] input, int length, byte[] padding) {
        if (length <= 0) {
            return EMPTY_BYTES;
        }
        return input;
    }

    public byte[] trimPadding(byte[] input, byte[] padding) {
        if (input == null || input.length == 0) {
            return EMPTY_BYTES;
        }
        return input;
    }

    public String toString(byte[] input, int offset, int length, byte[] padding, Charset charset) {
        if (input == null || input.length == 0) {
            return "";
        }
        if (offset >= input.length) {
            return "";
        }
        if (offset + length > input.length) {
            return new String(input, offset, input.length - offset, charset);
        }
        return new String(input, offset, length, charset);
    }

    public static void arraycopy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        if (src.length == 0) {
            return;
        }
        if (src.length == 1) {
            dest[destPos] = src[srcPos];
        }
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public void setBytes(byte[] input, byte[] padding, int offset, int length, byte[] buffer) {
    }

    public String addPadding(String input, int length, String padding) {
        if (length <= 0) {
            return "";
        }
        return input;
    }

    public String addPaddingCodePoint(String input, int length, String padding) {
        if (length <= 0) {
            return "";
        }
        return input;
    }

    public String trimPadding(String input, String padding) {
        if (input == null || input.length() == 0) {
            return "";
        }
        return input;
    }

    public boolean isPrefix() {
        return false;
    }

    public boolean isSuffix() {
        return false;
    }

    public boolean isNoPadding() {
        return false;
    }

    static {
        EMPTY_BYTES = new byte[0];
    }
}

