/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.TripleKeyMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class QuadKeyMap<S, T, U, V, W>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<S, TripleKeyMap<T, U, V, W>> innerMap = CommonUtils.linkedMap();

    public W get(S key1, T key2, U key3, V key4) {
        TripleKeyMap<U, V, V, W> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.get(key2, key3, key4);
    }

    public void put(S key1, T key2, U key3, V key4, W value) {
        TripleKeyMap<Object, Object, Object, Object> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            map2 = new TripleKeyMap();
            this.innerMap.put(key1, map2);
        }
        map2.put(key2, key3, key4, value);
    }

    public boolean containsKey(S key1, T key2, U key3, V key4) {
        TripleKeyMap<U, V, V, W> map2 = this.innerMap.get(key1);
        if (map2 != null) {
            return map2.containsKey(key2, key3, key4);
        }
        return false;
    }

    public W remove(S key1, T key2, U key3, V key4) {
        TripleKeyMap<U, V, V, W> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return null;
        }
        return map2.remove(key2, key3, key4);
    }

    public Set<S> keySet() {
        return this.innerMap.keySet();
    }

    public Set<T> secondKeySet() {
        Set result = CommonUtils.linkedSet();
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.entrySet()) {
            result.addAll(entry.getValue().keySet());
        }
        return result;
    }

    public Set<U> thirdKeySet() {
        Set result = CommonUtils.linkedSet();
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.entrySet()) {
            result.addAll(entry.getValue().secondKeySet());
        }
        return result;
    }

    public Set<V> fourthKeySet() {
        Set result = CommonUtils.linkedSet();
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.entrySet()) {
            result.addAll(entry.getValue().thirdKeySet());
        }
        return result;
    }

    public Set<Map.Entry<S, TripleKeyMap<T, U, V, W>>> entrySet() {
        return this.innerMap.entrySet();
    }

    public void clear() {
        this.innerMap.clear();
    }

    public void clear(S key1) {
        TripleKeyMap<T, U, V, W> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return;
        }
        map2.clear();
    }

    public void clear(S key1, T key2) {
        TripleKeyMap<T, U, V, W> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return;
        }
        map2.clear(key2);
    }

    public void clear(S key1, T key2, U key3) {
        TripleKeyMap<U, U, V, W> map2 = this.innerMap.get(key1);
        if (map2 == null) {
            return;
        }
        map2.clear(key2, key3);
    }

    public List<W> toList() {
        List list = CommonUtils.list();
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.entrySet()) {
            for (Map.Entry<T, DoubleKeyMap<U, V, W>> entry1 : entry.getValue().entrySet()) {
                for (Map.Entry<U, Map<V, W>> entry2 : entry1.getValue().entrySet()) {
                    for (Map.Entry<V, W> entry3 : entry2.getValue().entrySet()) {
                        list.add(entry3.getValue());
                    }
                }
            }
        }
        return list;
    }

    public TripleKeyMap<S, T, U, List<W>> toTripleKeyMapList() {
        TripleKeyMap tKeyMap = CommonUtils.tripleKeyMap();
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.entrySet()) {
            for (Map.Entry<T, DoubleKeyMap<U, V, W>> entry1 : entry.getValue().entrySet()) {
                for (Map.Entry<U, Map<V, W>> entry2 : entry1.getValue().entrySet()) {
                    List list = CommonUtils.list();
                    for (Map.Entry<V, W> entry3 : entry2.getValue().entrySet()) {
                        list.add(entry3.getValue());
                    }
                }
            }
        }
        return tKeyMap;
    }

    public int size() {
        int ret = 0;
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.innerMap.entrySet()) {
            ret += entry.getValue().size();
        }
        return ret;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.entrySet()) {
            for (Map.Entry<T, DoubleKeyMap<U, V, W>> entry1 : entry.getValue().entrySet()) {
                for (Map.Entry<U, Map<V, W>> entry2 : entry1.getValue().entrySet()) {
                    for (Map.Entry<V, W> entry3 : entry2.getValue().entrySet()) {
                        if (!first) {
                            builder.append(", ");
                        }
                        builder.append("{");
                        builder.append("(");
                        builder.append(entry.getKey());
                        builder.append(", ");
                        builder.append(entry1.getKey());
                        builder.append(", ");
                        builder.append(entry2.getKey());
                        builder.append(", ");
                        builder.append(entry3.getKey());
                        builder.append(")=");
                        builder.append(entry3.getValue());
                        builder.append("}");
                        first = false;
                    }
                }
            }
        }
        builder.append("]");
        return builder.toString();
    }

    public QuadKeyMap<S, T, U, V, W> clone() {
        QuadKeyMap<S, T, U, V, W> clone = new QuadKeyMap<S, T, U, V, W>();
        for (Map.Entry<S, TripleKeyMap<T, U, V, W>> entry : this.innerMap.entrySet()) {
            clone.innerMap.put(entry.getKey(), (TripleKeyMap<T, U, Object, W>)entry.getValue().clone());
        }
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QuadKeyMap)) {
            return false;
        }
        QuadKeyMap cst = (QuadKeyMap)obj;
        return this.innerMap.equals(cst.innerMap);
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.innerMap);
    }

    public static <S, T, U, V, W> QuadKeyMap<S, T, U, V, W> toMap(Collection<W> c, Function<W, S> func1, Function<W, T> func2, Function<W, U> func3, Function<W, V> func4) {
        if (c == null) {
            return CommonUtils.quadKeyMap();
        }
        QuadKeyMap result = CommonUtils.quadKeyMap();
        c.forEach(v -> {
            Object key1 = func1.apply(v);
            Object key2 = func2.apply(v);
            Object key3 = func3.apply(v);
            Object key4 = func4.apply(v);
            result.put(key1, key2, key3, key4, v);
        });
        return result;
    }

    public static <S, T, U, V, W> QuadKeyMap<S, T, U, V, List<W>> toListMap(Collection<W> c, Function<W, S> func1, Function<W, T> func2, Function<W, U> func3, Function<W, V> func4) {
        if (c == null) {
            return CommonUtils.quadKeyMap();
        }
        QuadKeyMap result = CommonUtils.quadKeyMap();
        c.forEach(v -> {
            Object key4;
            Object key3;
            Object key2;
            Object key1 = func1.apply(v);
            List list = (List)result.get(key1, key2 = func2.apply(v), key3 = func3.apply(v), key4 = func4.apply(v));
            if (list == null) {
                list = CommonUtils.list();
                result.put(key1, key2, key3, key4, list);
            }
            list.add(v);
        });
        return result;
    }
}

