/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractClassFinder;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileResourceSearcher;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.JarResourceSearcher;
import com.sqlapp.util.ResourceSearcher;
import com.sqlapp.util.Searcher;
import com.sqlapp.util.VfsResourceSearcher;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceFinder
extends AbstractClassFinder<ResourceInfo> {
    private String[] extensions = new String[]{"properties"};
    private Set<String> extensionSets = CommonUtils.set("properties");

    public ResourceFinder() {
    }

    public ResourceFinder(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected void itialize() {
        this.addResourceSearcher((Searcher)new VfsResourceSearcher());
        this.addResourceSearcher((Searcher)new JarResourceSearcher());
        this.addResourceSearcher((Searcher)new FileResourceSearcher());
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String ... extensions) {
        this.extensionSets = CommonUtils.set(extensions);
        this.extensions = this.extensionSets.toArray(new String[0]);
    }

    public List<ResourceInfo> find(String packageName) {
        ClassLoader classLoader = this.classLoader;
        List<ResourceInfo> list = this.findClasses(classLoader, packageName, false);
        return list;
    }

    public List<ResourceInfo> findRecursive(String packageName) {
        ClassLoader classLoader = this.classLoader;
        List<ResourceInfo> list = this.findClasses(classLoader, packageName, true);
        return list;
    }

    @Override
    protected void merge(List<ResourceInfo> resources, List<ResourceInfo> addResources) {
        resources.addAll(addResources);
    }

    protected static String getPath(URL url) {
        String file = url.getFile();
        try {
            return URLDecoder.decode(file, "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void initialize(Searcher<ResourceInfo> searcher) {
        ((ResourceSearcher)searcher).setExtensionSets(this.extensionSets);
    }

    public static class ResourceInfo {
        final URI uri;
        final ClassLoader classLoader;
        final String packageName;
        final String fileName;
        private static final Pattern UNICODE_PATTERN = Pattern.compile("\\\\u[0-9a-f]{4,4}");

        public ResourceInfo(URI uri, ClassLoader classLoader, String packageName, String fileName) {
            this.uri = uri;
            this.classLoader = classLoader;
            this.packageName = packageName;
            this.fileName = fileName;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<String> readAsText(String encoding) {
            List<String> list;
            if (CommonUtils.isEmpty(this.getFileName())) {
                return Collections.emptyList();
            }
            InputStream is = null;
            if (!"file".equals(this.uri.getScheme())) {
                String path = FileUtils.combinePath(this.packageName.replace(".", "/"), this.fileName);
                is = this.classLoader.getResourceAsStream(path);
                return FileUtils.readTextList(is, encoding);
            }
            try {
                is = new FileInputStream(ResourceFinder.getPath(this.uri.toURL()));
                list = FileUtils.readTextList(is, encoding);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                    catch (MalformedURLException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    throw throwable;
                }
            }
            FileUtils.close(is);
            return list;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public List<String> readAsText() {
            List<String> list;
            if (CommonUtils.isEmpty(this.getFileName())) {
                return Collections.emptyList();
            }
            InputStream is = null;
            if (!"file".equals(this.uri.getScheme())) {
                String path = FileUtils.combinePath(this.packageName.replace(".", "/"), this.fileName);
                is = this.classLoader.getResourceAsStream(path);
                return FileUtils.readTextList(is, null);
            }
            try {
                is = new FileInputStream(ResourceFinder.getPath(this.uri.toURL()));
                list = FileUtils.readTextList(is, null);
            }
            catch (FileNotFoundException e) {
                try {
                    throw new RuntimeException(e);
                    catch (MalformedURLException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    throw throwable;
                }
            }
            FileUtils.close(is);
            return list;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public URI getUri() {
            return this.uri;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
            builder.append("[");
            builder.append("packageName=").append(this.packageName);
            builder.append(", fileName=").append(this.fileName);
            builder.append(", uri=").append(this.uri);
            builder.append("]");
            return builder.toString();
        }

        public Map<String, String> readAsProperties() {
            return this.toPropertyMap(this.readAsText("ISO8859_1"));
        }

        public Map<String, String> readAsProperties(String encoding) {
            return this.toPropertyMap(this.readAsText(encoding));
        }

        /*
         * Enabled aggressive block sorting
         */
        private Map<String, String> toPropertyMap(List<String> texts) {
            Map<String, String> map = CommonUtils.map();
            int i = 0;
            String text;
            while ((text = this.getString(texts, i)) != null) {
                if (text.startsWith("#")) {
                    ++i;
                    continue;
                }
                if (!text.contains("=")) {
                    ++i;
                    continue;
                }
                int pos = text.indexOf(61);
                String key = text.substring(0, pos);
                StringBuilder builder = new StringBuilder();
                String value = text.substring(pos + 1);
                if (!value.endsWith("\\")) {
                    builder.append(this.convertValue(value));
                } else {
                    builder.append(this.convertValue(text));
                    int j = i + 1;
                    do {
                        value = this.getString(texts, j);
                        ++j;
                        if (value == null) break;
                        builder.append(this.convertValue(value));
                    } while (value.endsWith("\\"));
                }
                map.put(key, builder.toString());
                ++i;
            }
            return map;
        }

        private String getString(List<String> texts, int i) {
            if (i >= texts.size()) {
                return null;
            }
            return texts.get(i);
        }

        private String convertValue(String text) {
            Matcher matcher = UNICODE_PATTERN.matcher(text);
            List<MatchResult> matchResults = CommonUtils.list();
            while (matcher.find()) {
                MatchResult matchResult = matcher.toMatchResult();
                matchResults.add(matchResult);
            }
            for (MatchResult matchResult : matchResults) {
                String val = matchResult.group();
                String decode = this.convertToOiginal(val);
                text = text.replace(val, decode);
            }
            return this.trimLastValue(text);
        }

        private String convertToOiginal(String unicode) {
            String[] codeStrs = unicode.split("\\\\u");
            int[] codePoints = new int[codeStrs.length - 1];
            for (int i = 0; i < codePoints.length; ++i) {
                codePoints[i] = Integer.parseInt(codeStrs[i + 1], 16);
            }
            String encodedText = new String(codePoints, 0, codePoints.length);
            return encodedText;
        }

        private String trimLastValue(String text) {
            if (text.endsWith("\\")) {
                return text.substring(0, text.length() - 1);
            }
            return text;
        }
    }
}

