/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RuntimeExec {
    private ProcessBuilder processBuilder = null;
    private String charsetName = null;
    private List<String> stdout = null;
    private List<String> stderr = null;

    public RuntimeExec(String ... commands) {
        this.processBuilder = new ProcessBuilder(commands);
    }

    public RuntimeExec(List<String> command) {
        this.processBuilder = new ProcessBuilder(command);
    }

    public void setCharset(String charsetName) {
        this.charsetName = charsetName;
    }

    public List<String> stdout() {
        return this.stdout;
    }

    public List<String> stderr() {
        return this.stderr;
    }

    public Map<String, String> environment() {
        return this.processBuilder.environment();
    }

    public int exec() {
        Process process = null;
        try {
            process = this.processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StreamReaderThread stdoutThread = new StreamReaderThread(process.getInputStream(), this.charsetName);
        StreamReaderThread stderrThread = new StreamReaderThread(process.getErrorStream(), this.charsetName);
        stdoutThread.start();
        stderrThread.start();
        int ret = 0;
        try {
            ret = process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            stdoutThread.join();
            stderrThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.stdout = stdoutThread.getResult();
        this.stderr = stderrThread.getResult();
        return ret;
    }

    static class StreamReaderThread
    extends Thread {
        private BufferedReader reader = null;
        private List<String> result = new ArrayList<String>();

        public List<String> getResult() {
            return this.result;
        }

        public StreamReaderThread(InputStream stream, String charsetName) {
            try {
                this.reader = charsetName == null ? new BufferedReader(new InputStreamReader(stream)) : new BufferedReader(new InputStreamReader(stream, charsetName));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public StreamReaderThread(InputStream stream) {
            this.reader = new BufferedReader(new InputStreamReader(stream));
        }

        @Override
        public void run() {
            String line = null;
            try {
                while (this.reader.ready()) {
                    line = this.reader.readLine();
                    this.result.add(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            FileUtils.close(this.reader);
        }
    }
}

