/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.properties.NameProperty;
import com.sqlapp.data.schemas.properties.SpecificNameProperty;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SeparatedStringBuilder
implements Serializable {
    private static final long serialVersionUID = 6627317237113926725L;
    private String separator = ";";
    private boolean ignoreEmptyString = true;
    private boolean _trim = false;
    private boolean _exceptSameValue = false;
    private String openQuate = null;
    private String closeQuate = null;
    private String start = null;
    private String end = null;
    private List<String> elements = new ArrayList<String>();

    public SeparatedStringBuilder() {
    }

    public SeparatedStringBuilder(String separator) {
        this.separator = separator;
    }

    public int getCount() {
        return this.elements.size();
    }

    public List<String> getElements() {
        return this.elements;
    }

    public SeparatedStringBuilder add(Object obj) {
        if (obj == null) {
            this.addElement(null);
        } else {
            this.addElement(obj.toString());
        }
        return this;
    }

    public SeparatedStringBuilder add(Object ... args) {
        if (args != null) {
            for (Object arg : args) {
                this.add(arg);
            }
        }
        return this;
    }

    private SeparatedStringBuilder addElement(String val) {
        if (this.isIgnoreEmptyString() && (val == null || val.length() == 0)) {
            return this;
        }
        String trimValue = val;
        if (this._trim && val != null) {
            trimValue = val.trim();
        }
        if (this._exceptSameValue) {
            if (!this.elements.contains(trimValue)) {
                this.elements.add(trimValue);
            }
        } else {
            this.elements.add(trimValue);
        }
        return this;
    }

    public SeparatedStringBuilder add(String ... values) {
        if (values == null) {
            return this;
        }
        for (String val : values) {
            this.addElement(val);
        }
        return this;
    }

    public SeparatedStringBuilder add(Collection<?> values) {
        if (values == null) {
            return this;
        }
        for (Object val : values) {
            if (val != null) {
                this.addElement(val.toString());
                continue;
            }
            this.addElement(null);
        }
        return this;
    }

    public <T extends NameProperty<? super T>> SeparatedStringBuilder addNames(Collection<T> list) {
        for (NameProperty t : list) {
            String name;
            if (t instanceof SpecificNameProperty && !CommonUtils.isEmpty(name = ((SpecificNameProperty)((Object)t)).getSpecificName())) {
                this.add((Object)name);
                continue;
            }
            this.add((Object)t.getName());
        }
        return this;
    }

    public SeparatedStringBuilder addNames(Column ... columns) {
        for (Column column : columns) {
            this.add((Object)column.getName());
        }
        return this;
    }

    public SeparatedStringBuilder addFormat(String format, Object ... args) {
        return this.add((Object)String.format(format, args));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (!CommonUtils.isEmpty(this.start)) {
            builder.append(this.start);
        }
        int size = this.elements.size();
        boolean addElement = false;
        for (int i = 0; i < size; ++i) {
            String val = this.elements.get(i);
            if (addElement) {
                builder.append(this.separator);
            }
            if (!CommonUtils.isEmpty(this.openQuate)) {
                builder.append(this.openQuate);
            }
            builder.append(val);
            addElement = true;
            if (CommonUtils.isEmpty(this.closeQuate)) continue;
            builder.append(this.closeQuate);
        }
        if (!CommonUtils.isEmpty(this.end)) {
            builder.append(this.end);
        }
        return builder.toString();
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isIgnoreEmptyString() {
        return this.ignoreEmptyString;
    }

    public SeparatedStringBuilder setIgnoreEmptyString(boolean ignoreEmptyString) {
        this.ignoreEmptyString = ignoreEmptyString;
        return this;
    }

    public String getOpenQuate() {
        return this.openQuate;
    }

    public SeparatedStringBuilder setOpenQuate(String openQuate) {
        this.openQuate = openQuate;
        return this;
    }

    public String getCloseQuate() {
        return this.closeQuate;
    }

    public SeparatedStringBuilder setCloseQuate(String closeQuate) {
        this.closeQuate = closeQuate;
        return this;
    }

    public SeparatedStringBuilder setSeparator(String separator) {
        this.separator = separator;
        return this;
    }

    public String getStart() {
        return this.start;
    }

    public SeparatedStringBuilder setStart(String start) {
        this.start = start;
        return this;
    }

    public String getEnd() {
        return this.end;
    }

    public SeparatedStringBuilder setEnd(String end) {
        this.end = end;
        return this;
    }

    public boolean isExceptSameValue() {
        return this._exceptSameValue;
    }

    public SeparatedStringBuilder setExceptSameValue(boolean _exceptSameValue) {
        this._exceptSameValue = _exceptSameValue;
        return this;
    }
}

