/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.UniqueConstraint;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.SimpleBeanWrapper;
import com.sqlapp.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Index;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class SimpleBeanUtils {
    private static final Map<Class<?>, SimpleBeanWrapper> INSTANCE_CACHE = CommonUtils.concurrentMap();
    private static Converters converters = Converters.getDefault();
    private static Set<Class<?>> doesNotCloneClasses = CommonUtils.set();

    private SimpleBeanUtils() {
    }

    public static Converters getConverters() {
        return converters;
    }

    public static SimpleBeanWrapper getInstance(Class<?> clazz) {
        SimpleBeanWrapper instance = INSTANCE_CACHE.get(clazz);
        if (instance != null) {
            return instance;
        }
        instance = new SimpleBeanWrapper(clazz);
        SimpleBeanWrapper org = INSTANCE_CACHE.putIfAbsent(clazz, instance);
        return org != null ? org : instance;
    }

    public static SimpleBeanWrapper getInstance(String className) {
        Class clazz = CommonUtils.classForName(className);
        return SimpleBeanUtils.getInstance(clazz);
    }

    public static <T> T getValue(Object obj, String propertyName) {
        Map map;
        if (obj instanceof Map && (map = (Map)Map.class.cast(obj)).containsKey(propertyName)) {
            return (T)map.get(propertyName);
        }
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        return wrapper.getValue(obj, propertyName);
    }

    public static <T> T getValueCI(Object obj, String propertyName) {
        if (obj instanceof Map) {
            Map map = (Map)Map.class.cast(obj);
            if (map.containsKey(propertyName)) {
                return (T)map.get(propertyName);
            }
            if (map.containsKey(propertyName.toLowerCase())) {
                return (T)map.get(propertyName.toLowerCase());
            }
            if (map.containsKey(propertyName.toUpperCase())) {
                return (T)map.get(propertyName.toUpperCase());
            }
            for (Map.Entry entry : map.entrySet()) {
                String key = entry.getKey().toString();
                if (!key.equalsIgnoreCase(propertyName)) continue;
                return (T)entry.getValue();
            }
        }
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        return wrapper.getValueCI(obj, propertyName);
    }

    public static boolean setValueCI(Object obj, String propertyName, Object value) {
        return SimpleBeanUtils.setValueCI(obj, propertyName, value, false);
    }

    public static boolean setValueCI(Object obj, String propertyName, Object value, boolean force) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        boolean bool = wrapper.setValueCI(obj, propertyName, value, force);
        if (bool) {
            return bool;
        }
        if (obj instanceof Map) {
            Map map = (Map)Map.class.cast(obj);
            for (Map.Entry entry : map.entrySet()) {
                String key = ((String)entry.getKey()).toString();
                if (!key.equalsIgnoreCase(propertyName)) continue;
                map.put(key, value);
                return true;
            }
            map.put(propertyName, value);
            return true;
        }
        return false;
    }

    public static void setValuesCI(Collection<?> list, String propertyName, Object value) {
        for (Object obj : list) {
            SimpleBeanUtils.setValueCI(obj, propertyName, value);
        }
    }

    public static void setValues(Collection<?> list, String propertyName, Object value) {
        for (Object obj : list) {
            SimpleBeanUtils.setValue(obj, propertyName, value);
        }
    }

    public static boolean setValue(Object obj, String propertyName, Object value) {
        return SimpleBeanUtils.setValue(obj, propertyName, value, false);
    }

    public static boolean setValue(Object obj, String propertyName, Object value, boolean force) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        boolean bool = wrapper.setValue(obj, propertyName, value, force);
        if (bool) {
            return bool;
        }
        if (obj instanceof Map) {
            Map map = (Map)Map.class.cast(obj);
            map.put(propertyName, value);
        }
        return false;
    }

    public static <T> T getField(Object obj, String fieldName) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        return wrapper.getField(obj, fieldName);
    }

    public static <T> T getFieldCI(Object obj, String fieldName) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        return wrapper.getFieldCI(obj, fieldName);
    }

    public static boolean setField(Object obj, String fieldName, Object value) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        return wrapper.setField(obj, fieldName, value);
    }

    public static boolean setFieldCI(Object obj, String fieldName, Object value) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(obj.getClass());
        return wrapper.setFieldCI(obj, fieldName, value);
    }

    public static <T> T convert(Object fromObj, Class<T> toClazz) {
        return SimpleBeanUtils.convert(false, fromObj, toClazz);
    }

    private static Map toMap(Object fromObj, Class toClazz) {
        SimpleBeanWrapper toUtils = SimpleBeanUtils.getInstance(toClazz);
        Map toObj = (Map)toUtils.newInstance(new Object[0]);
        toObj.putAll(SimpleBeanUtils.toMap(fromObj));
        return toObj;
    }

    public static <T> T convertCI(Object fromObj, Class<T> toClazz) {
        return SimpleBeanUtils.convert(true, fromObj, toClazz);
    }

    protected static <T> T convert(boolean caseInsensitive, Object fromObj, Class<T> toClazz) {
        if (fromObj == null) {
            return null;
        }
        if (Map.class.isAssignableFrom(toClazz)) {
            Map toObj = SimpleBeanUtils.toMap(fromObj, toClazz);
            return (T)toObj;
        }
        SimpleBeanWrapper toUtils = SimpleBeanUtils.getInstance(toClazz);
        Object toObj = toUtils.newInstance(new Object[0]);
        SimpleBeanUtils.copyProperties(caseInsensitive, fromObj, toObj);
        return toObj;
    }

    public static <T> Set<T> convertSetCI(Collection<?> fromSet, Class<T> toClazz) {
        return SimpleBeanUtils.convertSet(true, fromSet, toClazz);
    }

    public static <T> Set<T> convertSet(Collection<?> fromSet, Class<T> toClazz) {
        return SimpleBeanUtils.convertSet(false, fromSet, toClazz);
    }

    protected static <T> Set<T> convertSet(boolean caseInsensitive, Collection<?> fromSet, Class<T> toClazz) {
        if (fromSet == null) {
            return null;
        }
        if (fromSet.size() == 0) {
            return new LinkedHashSet();
        }
        LinkedHashSet result = new LinkedHashSet(fromSet.size());
        SimpleBeanWrapper toUtils = SimpleBeanUtils.getInstance(toClazz);
        for (Object obj : fromSet) {
            Object toObj = toUtils.newInstance(new Object[0]);
            SimpleBeanUtils.copyProperties(caseInsensitive, obj, toObj);
            result.add(toObj);
        }
        return result;
    }

    protected static <T> Set<T> convertSet(boolean caseInsensitive, Collection<?> fromCllection, String propertyName) {
        if (fromCllection == null) {
            return null;
        }
        Set set = CommonUtils.linkedSet(fromCllection.size());
        if (fromCllection.size() == 0) {
            return set;
        }
        for (Object obj : fromCllection) {
            T value = SimpleBeanUtils.getValueRecursive(caseInsensitive, obj, propertyName);
            set.add(value);
        }
        return set;
    }

    public static <T> Set<T> convertSet(Collection<?> fromCllection, String propertyName) {
        return SimpleBeanUtils.convertSet(false, fromCllection, propertyName);
    }

    public static <T> Set<T> convertSetCI(Collection<?> fromCllection, String propertyName) {
        return SimpleBeanUtils.convertSet(true, fromCllection, propertyName);
    }

    public static <T> List<T> convertListCI(List<?> fromList, Class<T> toClazz) {
        return SimpleBeanUtils.convertList(true, fromList, toClazz);
    }

    public static <T> List<T> convertList(List<?> fromList, Class<T> toClazz) {
        return SimpleBeanUtils.convertList(false, fromList, toClazz);
    }

    protected static <T> List<T> convertList(boolean caseInsensitive, List<?> fromList, Class<T> toClazz) {
        if (fromList == null) {
            return null;
        }
        if (fromList.size() == 0) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList(fromList.size());
        SimpleBeanWrapper toUtils = SimpleBeanUtils.getInstance(toClazz);
        for (int i = 0; i < fromList.size(); ++i) {
            Object toObj = toUtils.newInstance(new Object[0]);
            SimpleBeanUtils.copyProperties(caseInsensitive, fromList.get(i), toObj);
            result.add(toObj);
        }
        return result;
    }

    protected static <T> List<T> convertList(boolean caseInsensitive, Collection<?> fromCllection, String propertyName) {
        if (fromCllection == null) {
            return null;
        }
        List list = CommonUtils.list(fromCllection.size());
        if (fromCllection.size() == 0) {
            return list;
        }
        for (Object obj : fromCllection) {
            T value = SimpleBeanUtils.getValueRecursive(caseInsensitive, obj, propertyName);
            list.add(value);
        }
        return list;
    }

    public static <T> List<T> convertList(Collection<?> fromCllection, String propertyName) {
        return SimpleBeanUtils.convertList(false, fromCllection, propertyName);
    }

    public static <T> List<T> convertListCI(Collection<?> fromCllection, String propertyName) {
        return SimpleBeanUtils.convertList(true, fromCllection, propertyName);
    }

    protected static <S, T> Map<S, T> convertMap(boolean caseInsensitive, Collection<T> fromCllection, String propertyName) {
        if (fromCllection == null) {
            return null;
        }
        LinkedHashMap<T, T> map = new LinkedHashMap<T, T>();
        if (fromCllection.size() == 0) {
            return map;
        }
        for (T obj : fromCllection) {
            T key = SimpleBeanUtils.getValueRecursive(caseInsensitive, obj, propertyName);
            map.put(key, obj);
        }
        return map;
    }

    private static <T> T getValueRecursive(boolean caseInsensitive, Object obj, String propertyName) {
        if (obj == null) {
            return null;
        }
        SimpleBeanWrapper utils = SimpleBeanUtils.getInstance(obj.getClass());
        String[] args = propertyName.split("\\.");
        if (args.length == 1) {
            return utils.getValue(caseInsensitive, obj, propertyName);
        }
        Object value = utils.getValue(caseInsensitive, obj, args[0]);
        return SimpleBeanUtils.getValueRecursive(caseInsensitive, value, propertyName.replaceFirst(args[0] + "\\.", ""));
    }

    public static <S, T> Map<S, T> convertMap(Collection<T> fromCllection, String propertyName) {
        return SimpleBeanUtils.convertMap(false, fromCllection, propertyName);
    }

    public static <S, T> Map<S, T> convertMapCI(Collection<T> fromCllection, String propertyName) {
        return SimpleBeanUtils.convertMap(true, fromCllection, propertyName);
    }

    public static void copyProperties(Object fromObj, Object toObj) {
        SimpleBeanUtils.copyProperties(false, fromObj, toObj);
    }

    public static void copyPropertiesCI(Object fromObj, Object toObj) {
        SimpleBeanUtils.copyProperties(true, fromObj, toObj);
    }

    protected static void copyProperties(boolean caseInsensitive, Object fromObj, Object toObj) {
        if (fromObj == null) {
            return;
        }
        if (toObj == null) {
            return;
        }
        SimpleBeanWrapper fromWrapper = SimpleBeanUtils.getInstance(fromObj.getClass());
        SimpleBeanWrapper toWrapper = SimpleBeanUtils.getInstance(toObj.getClass());
        Map<String, Object> map = fromObj instanceof Map ? (Map<String, Object>)fromObj : fromWrapper.toMap(fromObj, toWrapper, caseInsensitive);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object child = entry.getValue();
            if (child == null) {
                toWrapper.setValue(caseInsensitive, toObj, propertyName, null);
                continue;
            }
            if (child instanceof Iterable) {
                Class<?> toChildClass = toWrapper.getPropertyClass(caseInsensitive, propertyName);
                if (toChildClass == null) continue;
                if (toChildClass == Object.class) {
                    toWrapper.setValue(caseInsensitive, toObj, propertyName, SimpleBeanUtils.cloneValue(child));
                    continue;
                }
                if (!Collection.class.isAssignableFrom(toChildClass)) continue;
                Type toType = toWrapper.getPropertyGenericType(caseInsensitive, propertyName);
                if (toType == String.class && toWrapper.hasSetter(caseInsensitive, propertyName, child.getClass())) {
                    toWrapper.setValue(caseInsensitive, toObj, propertyName, SimpleBeanUtils.cloneValue(child));
                    continue;
                }
                Class<?> toGenericClass = SimpleBeanUtils.getGenericClass(toType, 0);
                Collection<?> c = SimpleBeanUtils.convertCollection(caseInsensitive, toChildClass, toGenericClass, entry);
                toWrapper.setValue(caseInsensitive, toObj, propertyName, c);
                continue;
            }
            if (toWrapper.hasSetter(caseInsensitive, propertyName, child.getClass())) {
                toWrapper.setValue(caseInsensitive, toObj, propertyName, SimpleBeanUtils.cloneValue(child));
                continue;
            }
            toWrapper.setValue(caseInsensitive, toObj, propertyName, SimpleBeanUtils.cloneValue(child));
        }
    }

    private static Object cloneValue(Object obj) {
        if (obj == null) {
            return null;
        }
        Class<?> clazz = obj.getClass();
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof Number) {
            return obj;
        }
        if (clazz.isEnum()) {
            return obj;
        }
        if (obj instanceof ArrayList) {
            return ((ArrayList)obj).clone();
        }
        if (obj instanceof Map) {
            return CommonUtils.cloneMap((Map)obj);
        }
        if (obj instanceof HashSet) {
            return ((HashSet)obj).clone();
        }
        if (SimpleBeanUtils.getConverters().isConvertable(clazz)) {
            return SimpleBeanUtils.getConverters().copy(obj);
        }
        if (clazz.isArray()) {
            int length = Array.getLength(obj);
            Object clone = Array.newInstance(clazz.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(obj, i);
                Array.set(clone, i, SimpleBeanUtils.cloneValue(element));
            }
            return clone;
        }
        if (doesNotCloneClasses.contains(clazz)) {
            return obj;
        }
        if (obj instanceof Cloneable) {
            try {
                Method method = clazz.getMethod("clone", new Class[0]);
                return method.invoke(obj, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                doesNotCloneClasses.add(clazz);
                return obj;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw SimpleBeanUtils.throwInvocationTargetException(e);
            }
        }
        return obj;
    }

    protected static RuntimeException throwInvocationTargetException(InvocationTargetException e) {
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        throw new RuntimeException(e);
    }

    private static Collection<?> convertCollection(boolean caseInsensitive, Class<?> toChildClass, Class<?> toGenericClass, Map.Entry<String, Object> entry) {
        Collection c = SimpleBeanUtils.getNewCollection(toChildClass);
        for (Object o : (Iterable)entry.getValue()) {
            if (toGenericClass != null) {
                if (SimpleBeanUtils.getConverters().isConvertable(toGenericClass)) {
                    c.add(SimpleBeanUtils.getConverters().convertObject(o, toGenericClass));
                    continue;
                }
                c.add(SimpleBeanUtils.convert(caseInsensitive, o, toGenericClass));
                continue;
            }
            Object newObj = SimpleBeanUtils.newInstance(o.getClass(), new Object[0]);
            SimpleBeanUtils.copyProperties(caseInsensitive, o, newObj);
            c.add(newObj);
        }
        return c;
    }

    private static Collection getNewCollection(Class<?> clazz) {
        return (Collection)SimpleBeanUtils.newInstance(clazz, new Object[0]);
    }

    private static Map getNewMap(Class<?> clazz) {
        return (Map)SimpleBeanUtils.newInstance(clazz, new Object[0]);
    }

    private static Class<?> getGenericClass(Type type, int no) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type aType = pt.getActualTypeArguments()[no];
            Class componentType = (Class)aType;
            return componentType;
        }
        return null;
    }

    public static Map<String, Object> toMap(Object val) {
        if (val == null) {
            return null;
        }
        SimpleBeanWrapper utils = SimpleBeanUtils.getInstance(val.getClass());
        return utils.toMap(val);
    }

    public static <T> T newInstance(Class clazz, Object ... initargs) {
        if (clazz.equals(Map.class)) {
            return (T)new LinkedHashMap();
        }
        if (clazz.equals(Set.class)) {
            return (T)new LinkedHashSet();
        }
        if (clazz.equals(List.class)) {
            return (T)new ArrayList();
        }
        return SimpleBeanUtils.getInstance(clazz).newInstance(initargs);
    }

    public static Class<?> getPropertyClass(Class<?> clazz, String propertyName) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getPropertyClass(propertyName);
    }

    public static Type getPropertyGenericType(Class<?> clazz, String propertyName) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getPropertyGenericType(propertyName);
    }

    public static Map<String, Class<?>> getPropertyClassMap(Class<?> clazz) {
        LinkedHashMap map = new LinkedHashMap();
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        for (String name : wrapper.getPropertyNames()) {
            map.put(name, wrapper.getPropertyClass(name));
        }
        return map;
    }

    public static Map<String, Annotation[]> getPropertyAnnotationMap(Class<?> clazz) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getPropertyAnnotationMap();
    }

    public static <T extends Annotation> Map<String, T> getPropertyAnnotation(Class<?> clazz, Class<T> annotationClass) {
        Map<String, Annotation[]> annotationMap = SimpleBeanUtils.getPropertyAnnotationMap(clazz);
        Map result = CommonUtils.map();
        block0: for (Map.Entry<String, Annotation[]> entry : annotationMap.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                if (!annotationClass.equals(annotation.annotationType())) continue;
                result.put(entry.getKey(), annotation);
                continue block0;
            }
        }
        return result;
    }

    public static <T extends Annotation> Map<String, List<T>> getPropertyAnnotations(Class<?> clazz, Class<T> annotationClass) {
        Map<String, Annotation[]> annotationMap = SimpleBeanUtils.getPropertyAnnotationMap(clazz);
        Map<String, List<T>> result = CommonUtils.map();
        for (Map.Entry<String, Annotation[]> entry : annotationMap.entrySet()) {
            List annotations = CommonUtils.list();
            for (Annotation annotation : entry.getValue()) {
                if (!annotationClass.equals(annotation.annotationType())) continue;
                annotations.add(annotation);
                break;
            }
            if (annotations.isEmpty()) continue;
            result.put(entry.getKey(), annotations);
        }
        return result;
    }

    public static <T extends Annotation> Map<String, T> filterAnnotation(Map<String, Annotation[]> prop, Class<T> annotationClass) {
        Map map = CommonUtils.map();
        block0: for (Map.Entry<String, Annotation[]> entry : prop.entrySet()) {
            for (Annotation annotation : entry.getValue()) {
                if (!annotationClass.equals(annotation.annotationType())) continue;
                map.put(entry.getKey(), annotation);
                continue block0;
            }
        }
        return map;
    }

    public static Map<String, Annotation[]> getGetterAnnotationMap(Class<?> clazz) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getGetterAnnotationMap();
    }

    public static Map<String, Annotation[]> getSetterAnnotationMap(Class<?> clazz) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getSetterAnnotationMap();
    }

    public static Map<String, Annotation[]> getFieldAnnotationMap(Class<?> clazz) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getFieldAnnotationMap();
    }

    public static Map<String, Type> getPropertyGenericTypeMap(Class<?> clazz) {
        LinkedHashMap<String, Type> map = new LinkedHashMap<String, Type>();
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        for (String name : wrapper.getPropertyNames()) {
            map.put(name, wrapper.getPropertyGenericType(name));
        }
        return map;
    }

    public static Set<String> getPropertyNames(Class<?> clazz) {
        SimpleBeanWrapper wrapper = SimpleBeanUtils.getInstance(clazz);
        return wrapper.getPropertyNames();
    }

    public static Table toTable(Class<?> clazz, Predicate<com.sqlapp.data.schemas.Column> primaryPredicate, boolean toSnakecase) {
        if (toSnakecase) {
            return SimpleBeanUtils.toTable(clazz, primaryPredicate, name -> StringUtils.camelToSnake(name));
        }
        return SimpleBeanUtils.toTable(clazz, primaryPredicate, name -> name);
    }

    public static Table toTable(Class<?> clazz, Predicate<com.sqlapp.data.schemas.Column> primaryPredicate, Function<String, String> nameConverter) {
        com.sqlapp.data.schemas.Column[] columns;
        Annotation[] classAnnotations = clazz.getAnnotations();
        Map<String, Annotation[]> annotationMap = SimpleBeanUtils.getPropertyAnnotationMap(clazz);
        Table table = new Table();
        Optional<javax.persistence.Table> optionalTable = SimpleBeanUtils.getAnnotation(javax.persistence.Table.class, classAnnotations);
        Index[] jpaIndexes = null;
        javax.persistence.UniqueConstraint[] jpaUcs = null;
        Map<String, com.sqlapp.data.schemas.Column> nameColumnMap = CommonUtils.linkedMap();
        if (optionalTable.isPresent()) {
            javax.persistence.Table pTable = optionalTable.get();
            table.setName(pTable.name());
            table.setSchemaName(pTable.name());
            table.setCatalogName(pTable.catalog());
            jpaIndexes = pTable.indexes();
            jpaUcs = pTable.uniqueConstraints();
        } else {
            table.setName(nameConverter.apply(clazz.getSimpleName()));
        }
        List<com.sqlapp.data.schemas.Column> primaries = CommonUtils.list();
        List<com.sqlapp.data.schemas.Column> uniqueColumns = CommonUtils.list();
        for (String name : SimpleBeanUtils.getPropertyNames(clazz)) {
            Optional<GeneratedValue> optionalGeneratedValue;
            Optional<Column> optionalColumn;
            com.sqlapp.data.schemas.Column column = table.newColumn();
            Class<?> propClass = SimpleBeanUtils.getPropertyClass(clazz, name);
            DataType dataType = DataType.valueOf(propClass);
            column.setDataType(dataType);
            Annotation[] annotationArray = annotationMap.get(name);
            column.setName(nameConverter.apply(name));
            Optional<NotNull> optionalNotNull = SimpleBeanUtils.getAnnotation(NotNull.class, annotationArray);
            if (propClass.isPrimitive()) {
                column.setNotNull(true);
            } else if (optionalNotNull.isPresent()) {
                column.setNotNull(true);
            } else {
                Optional<NotEmpty> optionalNotEmpty = SimpleBeanUtils.getAnnotation(NotEmpty.class, annotationArray);
                if (optionalNotEmpty.isPresent()) {
                    column.setNotNull(true);
                    column.setDefaultValue("");
                } else {
                    Optional<NotBlank> optionalNotBlank = SimpleBeanUtils.getAnnotation(NotBlank.class, annotationArray);
                    column.setNotNull(optionalNotBlank.isPresent());
                }
            }
            Optional<Size> optionalSize = SimpleBeanUtils.getAnnotation(Size.class, annotationArray);
            if (optionalSize.isPresent()) {
                int max = optionalSize.get().max();
                if (!byte[].class.equals(propClass)) {
                    if (!propClass.isArray()) {
                        column.setLength(max);
                    } else {
                        column.setArrayDimension(1);
                        column.setArrayDimensionUpperBound(max);
                    }
                }
            }
            if ((optionalColumn = SimpleBeanUtils.getAnnotation(Column.class, annotationArray)).isPresent()) {
                Column jpaColumn = optionalColumn.get();
                if (!CommonUtils.isEmpty(jpaColumn.name())) {
                    column.setName(jpaColumn.name());
                }
                column.setNotNull(!jpaColumn.nullable() || propClass.isPrimitive());
                if (column.getDataType().isCharacter()) {
                    column.setLength(jpaColumn.length());
                } else if (column.getDataType().isNumeric()) {
                    column.setLength(jpaColumn.precision());
                }
                if (column.getDataType().isFixedScale()) {
                    column.setScale(jpaColumn.scale());
                }
                if (jpaColumn.unique()) {
                    uniqueColumns.add(column);
                }
            }
            if ((optionalGeneratedValue = SimpleBeanUtils.getAnnotation(GeneratedValue.class, annotationArray)).isPresent()) {
                GeneratedValue generatedValue = optionalGeneratedValue.get();
                if (GenerationType.IDENTITY == generatedValue.strategy()) {
                    column.setIdentity(true);
                }
                if (GenerationType.SEQUENCE == generatedValue.strategy()) {
                    column.setSchemaName(table.getName() + "_" + column.getName() + "_seq");
                }
            }
            if (primaryPredicate.test(column)) {
                primaries.add(column);
            }
            nameColumnMap.put(column.getName(), column);
            nameColumnMap.put(name, column);
            table.getColumns().add(column);
        }
        table.setPrimaryKey(primaries.toArray(new com.sqlapp.data.schemas.Column[0]));
        int ucNo = 1;
        int indexNo = 1;
        for (com.sqlapp.data.schemas.Column uniqueColumn : uniqueColumns) {
            UniqueConstraint uc = new UniqueConstraint("UK_" + table.getName() + ucNo++, uniqueColumn);
            table.getConstraints().add(uc);
        }
        if (jpaIndexes != null) {
            for (Index index : jpaIndexes) {
                if (CommonUtils.isEmpty(index.columnList()) || CommonUtils.isEmpty(columns = SimpleBeanUtils.getColumns(nameColumnMap, StringUtils.trim(index.columnList().split(","))))) continue;
                com.sqlapp.data.schemas.Index index2 = new com.sqlapp.data.schemas.Index("UK_" + table.getName() + indexNo++, columns);
                index2.setUnique(index.unique());
                table.getIndexes().add(index2);
            }
        }
        if (jpaIndexes != null) {
            for (Index index : jpaUcs) {
                if (CommonUtils.isEmpty(index.columnNames()) || CommonUtils.isEmpty(columns = SimpleBeanUtils.getColumns(nameColumnMap, StringUtils.trim(index.columnNames())))) continue;
                UniqueConstraint uc = new UniqueConstraint("UK_" + table.getName() + ucNo++, columns);
                table.getConstraints().add(uc);
            }
        }
        return table;
    }

    private static com.sqlapp.data.schemas.Column[] getColumns(Map<String, com.sqlapp.data.schemas.Column> nameColumnMap, String ... names) {
        com.sqlapp.data.schemas.Column[] columns = new com.sqlapp.data.schemas.Column[names.length];
        int i = 0;
        for (String name : names) {
            com.sqlapp.data.schemas.Column column = nameColumnMap.get(name);
            if (column == null) {
                return null;
            }
            columns[i] = column;
            ++i;
        }
        return columns;
    }

    private static <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz, Annotation[] args) {
        if (args == null) {
            return Optional.empty();
        }
        for (Annotation arg : args) {
            if (!clazz.isInstance(arg)) continue;
            return Optional.of((Annotation)clazz.cast(arg));
        }
        return Optional.empty();
    }
}

