/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.util.DbUtils;
import com.sqlapp.util.FlexList;
import com.sqlapp.util.SeparatedStringBuilder;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class SqlExecuter {
    private StringBuilder sql = new StringBuilder();
    private List<Object> parameters = new ArrayList<Object>();
    private List<Integer> jdbcTypes = new FlexList<Integer>();

    public SqlExecuter() {
    }

    public SqlExecuter(String sql) {
        this.sql.append(sql);
    }

    public SqlExecuter addSql(String part) {
        this.sql.append(part);
        return this;
    }

    public SqlExecuter addAnd(String part) {
        this.sql.append(" AND");
        return this;
    }

    public SqlExecuter addSqlLine(String part) {
        this.sql.append('\n').append(part);
        return this;
    }

    public SqlExecuter addParameter(int jdbcType, Object ... vals) {
        for (Object val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(jdbcType);
        }
        return this;
    }

    public SqlExecuter addVarcharParameter(String ... vals) {
        for (String val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(12);
        }
        return this;
    }

    public SqlExecuter addInVarcharParameter(String ... vals) {
        for (String val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(12);
        }
        this.addInParameter(vals.length);
        return this;
    }

    public SqlExecuter addInNVarcharParameter(String ... vals) {
        for (String val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(-9);
        }
        this.addInParameter(vals.length);
        return this;
    }

    public SqlExecuter addInParameter(int jdbcType, Object ... vals) {
        for (Object val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(jdbcType);
        }
        this.addInParameter(vals.length);
        return this;
    }

    private void addInParameter(int paramCount) {
        SeparatedStringBuilder sep = new SeparatedStringBuilder(", ");
        for (int i = 0; i < paramCount; ++i) {
            sep.add((Object)"?");
        }
        if (paramCount > 0) {
            this.sql.append('(');
            this.sql.append(sep.toString());
            this.sql.append(')');
        }
    }

    public SqlExecuter addCharParameter(String ... vals) {
        for (String val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(1);
        }
        return this;
    }

    public SqlExecuter addNVarcharParameter(String ... vals) {
        for (String val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(-9);
        }
        return this;
    }

    public SqlExecuter addNcharParameter(String ... vals) {
        for (String val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(-9);
        }
        return this;
    }

    public SqlExecuter addParameter(Object val) {
        this.parameters.add(val);
        if (val == null) {
            this.jdbcTypes.add(0);
        } else {
            this.jdbcTypes.add(null);
        }
        return this;
    }

    public SqlExecuter addParameter(Boolean ... vals) {
        for (Boolean val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(16);
        }
        return this;
    }

    public SqlExecuter addParameter(Short ... vals) {
        for (Short val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(5);
        }
        return this;
    }

    public SqlExecuter addParameter(Byte ... vals) {
        for (Byte val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(-6);
        }
        return this;
    }

    public SqlExecuter addParameter(Integer ... vals) {
        for (Integer val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(4);
        }
        return this;
    }

    public SqlExecuter addParameter(Long ... vals) {
        for (Long val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(-5);
        }
        return this;
    }

    public SqlExecuter addParameter(java.util.Date ... vals) {
        for (java.util.Date val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(93);
        }
        return this;
    }

    public SqlExecuter addParameter(Date ... vals) {
        for (Date val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(91);
        }
        return this;
    }

    public SqlExecuter addParameter(Time ... vals) {
        for (Time val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(92);
        }
        return this;
    }

    public SqlExecuter addParameter(Timestamp ... vals) {
        for (Timestamp val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(93);
        }
        return this;
    }

    public SqlExecuter addParameter(BigDecimal ... vals) {
        for (BigDecimal val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(3);
        }
        return this;
    }

    public SqlExecuter addParameter(Double ... vals) {
        for (Double val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(8);
        }
        return this;
    }

    public SqlExecuter addParameter(Float ... vals) {
        for (Float val : vals) {
            this.parameters.add(val);
            this.jdbcTypes.add(6);
        }
        return this;
    }

    public int parameterSize() {
        return this.parameters.size();
    }

    public PreparedStatement createPreparedStatement(Connection connection) {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.sql.toString());
            for (int i = 0; i < this.parameters.size(); ++i) {
                Object val = this.parameters.get(i);
                Integer jdbcType = this.jdbcTypes.get(i);
                if (jdbcType != null) {
                    statement.setObject(i + 1, val, jdbcType);
                    continue;
                }
                statement.setObject(i + 1, val);
            }
            return statement;
        }
        catch (SQLException e) {
            DbUtils.close(statement);
            throw new RuntimeException(e);
        }
    }

    public <T> T executeScalar(Connection connection, Class<T> clazz, int columnIndex) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createPreparedStatement(connection);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                return null;
            }
            Object val = resultSet.getObject(columnIndex);
            return Converters.getDefault().convertObject(val, clazz);
        }
        catch (SQLException e) {
            DbUtils.close(resultSet);
            DbUtils.close(statement);
            throw new RuntimeException(e);
        }
    }

    public <T> T executeScalar(Connection connection, Class<T> clazz, String columnName) {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createPreparedStatement(connection);
            resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                return null;
            }
            Object val = resultSet.getObject(columnName);
            return Converters.getDefault().convertObject(val, clazz);
        }
        catch (SQLException e) {
            DbUtils.close(resultSet);
            DbUtils.close(statement);
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.sql.toString();
    }
}

