/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util;

import com.sqlapp.util.AbstractClassSearcher;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.VfsUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class VfsClassSearcher
extends AbstractClassSearcher {
    private static final String[] PROTOCOLS = new String[]{"vfs"};

    @Override
    public <T> List<Class<?>> search(String packageName, URL url, boolean recursive) {
        URLConnection urlConnection;
        List<Class<?>> classes = CommonUtils.list();
        try {
            urlConnection = url.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Object virtualFile = VfsUtils.getContent(urlConnection);
        if (VfsUtils.isFile(virtualFile)) {
            File file = VfsUtils.getPhisicalFile(virtualFile);
            if (!this.isClassFile(file.getAbsolutePath())) {
                return classes;
            }
            try {
                Class<?> clazz = this.getClassLoader().loadClass(packageName + "." + this.fileNameToClassName(file.getName()));
                if (this.getFilter().test(clazz)) {
                    classes.add(clazz);
                }
                return classes;
            }
            catch (Exception e) {
                this.getExceptionHandler().accept(e);
            }
            catch (ClassFormatError e) {
                this.getExceptionHandler().accept(e);
            }
        }
        Object children = VfsUtils.getChildren(virtualFile);
        int length = Array.getLength(children);
        for (int i = 0; i < length; ++i) {
            Object child = Array.get(children, i);
            File file = VfsUtils.getPhisicalFile(child);
            if (file.isFile()) {
                if (!this.isClassFile(file.getName())) continue;
                try {
                    Class<?> clazz = this.getClassLoader().loadClass(packageName + "." + this.fileNameToClassName(file.getName()));
                    if (!this.getFilter().test(clazz)) continue;
                    classes.add(clazz);
                }
                catch (Exception e) {
                    this.getExceptionHandler().accept(e);
                }
                catch (ClassFormatError e) {
                    this.getExceptionHandler().accept(e);
                }
                continue;
            }
            if (!recursive) continue;
            List<Class<?>> cls = this.search(packageName + "." + file.getName(), VfsUtils.toURL(child), recursive);
            classes.addAll(cls);
        }
        return classes;
    }

    @Override
    public String[] supportProtocols() {
        return PROTOCOLS;
    }
}

