/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;

final class LocalDateTimeIntervalIterator
extends AbstractObjectIterator<LocalDateTime, Interval> {
    private static final long serialVersionUID = 1L;

    public LocalDateTimeIntervalIterator(LocalDateTime start, LocalDateTime end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            return ((LocalDateTime)this.next).compareTo((ChronoLocalDateTime)this.end) < 0;
        }
        return ((LocalDateTime)this.next).compareTo((ChronoLocalDateTime)this.end) > 0;
    }

    @Override
    protected LocalDateTime getNext() {
        return ((Interval)this.step).add((LocalDateTime)this.start, (int)this.count);
    }

    public LocalDateTimeIntervalIterator clone() {
        LocalDateTimeIntervalIterator clone = new LocalDateTimeIntervalIterator((LocalDateTime)this.start, (LocalDateTime)this.end, (Interval)this.step);
        return clone;
    }
}

