/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.Java8DateUtils;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.LocalTime;

final class LocalTimeIterator
extends AbstractObjectIterator<LocalTime, Integer> {
    private static final long serialVersionUID = 1L;

    public LocalTimeIterator(LocalTime start, LocalTime end) {
        this(start, end, 3600);
    }

    public LocalTimeIterator(LocalTime start, LocalTime end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            if (((LocalTime)this.start).compareTo((LocalTime)this.next) >= 0) {
                return false;
            }
            if (((LocalTime)this.next).compareTo((LocalTime)this.end) < 0) {
                return true;
            }
        } else {
            if (((LocalTime)this.start).compareTo((LocalTime)this.next) <= 0) {
                return false;
            }
            if (((LocalTime)this.next).compareTo((LocalTime)this.end) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected LocalTime getNext() {
        return Java8DateUtils.addSeconds((LocalTime)this.current, (Integer)this.step);
    }

    public LocalTimeIterator clone() {
        LocalTimeIterator clone = new LocalTimeIterator((LocalTime)this.start, (LocalTime)this.end, (Integer)this.step);
        return clone;
    }
}

