/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.ToStringBuilder;
import java.io.Serializable;
import java.util.Iterator;

class LongIterator
implements Iterator<Long>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final long start;
    private final long end;
    private final long step;
    private long current = 0L;
    private boolean first = true;

    public LongIterator(long end) {
        this(0L, end, 1L);
    }

    public LongIterator(long start, long end) {
        this(start, end, 1L);
    }

    public LongIterator(long start, long end, long step) {
        assert (step != 0L);
        assert (start < end && step > 0L || start > end && step < 0L);
        this.start = start;
        this.end = end;
        this.step = step;
        this.current = start;
    }

    @Override
    public boolean hasNext() {
        if (this.step > 0L) {
            return this.current + this.step < this.end;
        }
        return this.current + this.step > this.end;
    }

    @Override
    public Long next() {
        if (this.first) {
            this.first = false;
            return this.current;
        }
        this.current += this.step;
        return this.current;
    }

    @Override
    public void remove() {
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(LongIterator.class);
        builder.add("start", this.start);
        builder.add("end", this.end);
        builder.add("step", this.step);
        builder.add("current", this.current);
        return builder.toString();
    }

    public int hashCode() {
        return (int)((this.start ^ this.end ^ this.step ^ this.current) >> 32);
    }

    public LongIterator clone() {
        LongIterator clone = new LongIterator(this.start, this.end, this.step);
        return clone;
    }
}

