/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.OffsetDateTime;

final class OffsetDateTimeIterator
extends AbstractObjectIterator<OffsetDateTime, Integer> {
    private static final long serialVersionUID = 1L;

    public OffsetDateTimeIterator(OffsetDateTime start, OffsetDateTime end) {
        this(start, end, 86400);
    }

    public OffsetDateTimeIterator(OffsetDateTime start, OffsetDateTime end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((OffsetDateTime)this.next).compareTo((OffsetDateTime)this.end) < 0;
        }
        return ((OffsetDateTime)this.next).compareTo((OffsetDateTime)this.end) > 0;
    }

    @Override
    protected OffsetDateTime getNext() {
        return ((OffsetDateTime)this.current).plusSeconds(((Integer)this.step).intValue());
    }

    public OffsetDateTimeIterator clone() {
        OffsetDateTimeIterator clone = new OffsetDateTimeIterator((OffsetDateTime)this.start, (OffsetDateTime)this.end, (Integer)this.step);
        return clone;
    }
}

