/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.data.interval.Interval;
import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.OffsetTime;

final class OffsetTimeIntervalIterator
extends AbstractObjectIterator<OffsetTime, Interval> {
    private static final long serialVersionUID = 1L;

    public OffsetTimeIntervalIterator(OffsetTime start, OffsetTime end, Interval step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if (((Interval)this.step).isPositive()) {
            if (((OffsetTime)this.start).compareTo((OffsetTime)this.next) >= 0) {
                return false;
            }
            if (((OffsetTime)this.next).compareTo((OffsetTime)this.end) < 0) {
                return true;
            }
        } else {
            if (((OffsetTime)this.start).compareTo((OffsetTime)this.next) <= 0) {
                return false;
            }
            if (((OffsetTime)this.next).compareTo((OffsetTime)this.end) > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected OffsetTime getNext() {
        return ((Interval)this.step).add((OffsetTime)this.start, (int)this.count);
    }

    public OffsetTimeIntervalIterator clone() {
        OffsetTimeIntervalIterator clone = new OffsetTimeIntervalIterator((OffsetTime)this.start, (OffsetTime)this.end, (Interval)this.step);
        return clone;
    }
}

