/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.iterator;

import com.sqlapp.util.iterator.AbstractObjectIterator;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;

final class ZonedDateTimeIterator
extends AbstractObjectIterator<ZonedDateTime, Integer> {
    private static final long serialVersionUID = 1L;

    public ZonedDateTimeIterator(ZonedDateTime start, ZonedDateTime end) {
        this(start, end, 86400);
    }

    public ZonedDateTimeIterator(ZonedDateTime start, ZonedDateTime end, Integer step) {
        super(start, end, step);
    }

    @Override
    public boolean hasNext() {
        if ((Integer)this.step > 0) {
            return ((ZonedDateTime)this.next).compareTo((ChronoZonedDateTime)this.end) < 0;
        }
        return ((ZonedDateTime)this.next).compareTo((ChronoZonedDateTime)this.end) > 0;
    }

    @Override
    protected ZonedDateTime getNext() {
        return ((ZonedDateTime)this.current).plusSeconds(((Integer)this.step).intValue());
    }

    public ZonedDateTimeIterator clone() {
        ZonedDateTimeIterator clone = new ZonedDateTimeIterator((ZonedDateTime)this.start, (ZonedDateTime)this.end, (Integer)this.step);
        return clone;
    }
}

