/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.util.xml;

import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.StaxReader;
import com.sqlapp.util.ToStringBuilder;
import com.sqlapp.util.xml.StaxElementHandler;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public abstract class AbstractStaxElementHandler
implements StaxElementHandler {
    private String namespaceURI = null;
    private StaxElementHandler parent = null;
    private StaxElementHandler[] childs = new StaxElementHandler[0];
    private Map<String, StaxElementHandler> childMap = CommonUtils.upperMap();

    protected AbstractStaxElementHandler() {
    }

    @Override
    public boolean handle(StaxReader reader, Object parentObject) throws XMLStreamException {
        if (!this.match(reader)) {
            return false;
        }
        if (reader.isEndDocument()) {
            return true;
        }
        if (reader.isStartDocument()) {
            reader.next();
        }
        this.doHandle(reader, parentObject);
        return true;
    }

    protected void callChilds(StaxReader reader, Object ownObject) throws XMLStreamException {
        while (reader.hasNext()) {
            this.callChild(reader, ownObject);
            if (!this.match(reader) || !reader.isEndElement()) continue;
            break;
        }
    }

    private void callChild(StaxReader reader, Object parentObject) throws XMLStreamException {
        boolean ret;
        String localName;
        StaxElementHandler child;
        if (reader.isStartElement() && CommonUtils.isEmpty(reader.getNamespaceURI()) && (child = this.childMap.get(localName = reader.getLocalName())) != null && (ret = child.handle(reader, parentObject))) {
            return;
        }
        for (StaxElementHandler child2 : this.childs) {
            boolean ret2 = child2.handle(reader, parentObject);
            if (!ret2) continue;
            return;
        }
        reader.raiseElementException(this.getLocalName());
    }

    @Override
    public boolean match(StaxReader reader) {
        if (reader.isStartElement() || reader.isEndElement()) {
            String localName = reader.getLocalName();
            String namespaceURI = reader.getNamespaceURI();
            if (CommonUtils.eq(localName, this.getLocalName()) && CommonUtils.eq(CommonUtils.emptyToNull(namespaceURI), CommonUtils.emptyToNull(this.getNamespaceURI()))) {
                return true;
            }
            return CommonUtils.eqIgnoreCase(localName, this.getLocalName()) && CommonUtils.eqIgnoreCase(CommonUtils.emptyToNull(namespaceURI), CommonUtils.emptyToNull(this.getNamespaceURI()));
        }
        return false;
    }

    protected abstract void doHandle(StaxReader var1, Object var2) throws XMLStreamException;

    protected void callParent(StaxReader reader, String name, Object parentObject, Object value) throws XMLStreamException {
        if (this.getParent() != null) {
            this.getParent().callback(reader, name, parentObject, value);
        }
    }

    @Override
    public void callback(StaxReader reader, String name, Object parentObject, Object value) throws XMLStreamException {
        if (value == null && !reader.hasNext()) {
            return;
        }
        this.doCallback(reader, this, name, parentObject, value);
    }

    protected abstract void doCallback(StaxReader var1, StaxElementHandler var2, String var3, Object var4, Object var5) throws XMLStreamException;

    protected Map<String, String> getAttributeMap(StaxReader reader) {
        int size = reader.getAttributeCount();
        Map<String, String> map = CommonUtils.map(size, 1.0f);
        for (int i = 0; i < size; ++i) {
            String key = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    @Override
    public StaxElementHandler getParent() {
        return this.parent;
    }

    public void setNamespaceURI(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    @Override
    public void setParent(StaxElementHandler parent) {
        this.parent = parent;
    }

    protected void registerChild(String localName, String namespaceURI, StaxElementHandler child) {
        child.setParent(this);
        if (CommonUtils.isEmpty(namespaceURI) && !CommonUtils.isEmpty(localName)) {
            this.childMap.put(localName, child);
        } else {
            List<StaxElementHandler[]> list = CommonUtils.list(this.childs);
            list.add((StaxElementHandler[])child);
            this.childs = list.toArray(new StaxElementHandler[0]);
        }
    }

    protected void registerChild(String localName, StaxElementHandler child) {
        this.registerChild(localName, null, child);
    }

    @Override
    public void registerChild(StaxElementHandler child) {
        this.registerChild(child.getLocalName(), child.getNamespaceURI(), child);
    }

    protected void setChilds(StaxElementHandler ... childs) {
        List<StaxElementHandler[]> list = CommonUtils.list(this.childs);
        for (StaxElementHandler child : childs) {
            child.setParent(this);
            if (CommonUtils.isEmpty(child.getNamespaceURI()) && !CommonUtils.isEmpty(child.getLocalName())) {
                this.childMap.put(child.getLocalName(), child);
                continue;
            }
            list.add((StaxElementHandler[])child);
        }
        this.childs = list.toArray(new StaxElementHandler[0]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractStaxElementHandler)) {
            return false;
        }
        AbstractStaxElementHandler val = (AbstractStaxElementHandler)CommonUtils.cast(obj);
        if (!CommonUtils.eq(this.getLocalName(), val.getLocalName())) {
            return false;
        }
        if (!CommonUtils.eq(this.getNamespaceURI(), val.getNamespaceURI())) {
            return false;
        }
        return CommonUtils.eq(this.getClass(), val.getClass());
    }

    public int hashCode() {
        return CommonUtils.hashCode(this.getLocalName(), this.getNamespaceURI());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(this.getClass());
        builder.add("localName", this.getLocalName());
        return builder.toString();
    }
}

