/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.mockwebserver;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class QueueDispatcher
extends Dispatcher {
    private static final MockResponse DEAD_LETTER = new MockResponse().setStatus("HTTP/1.1 503 shutting down");
    private static final Logger logger = Logger.getLogger(QueueDispatcher.class.getName());
    protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();
    private MockResponse failFastResponse;

    @Override
    public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
        String requestLine = request.getRequestLine();
        if (requestLine != null && requestLine.equals("GET /favicon.ico HTTP/1.1")) {
            logger.info("served " + requestLine);
            return new MockResponse().setResponseCode(404);
        }
        if (this.failFastResponse != null && this.responseQueue.peek() == null) {
            return this.failFastResponse;
        }
        MockResponse result = this.responseQueue.take();
        if (result == DEAD_LETTER) {
            this.responseQueue.add(DEAD_LETTER);
        }
        return result;
    }

    @Override
    public MockResponse peek() {
        MockResponse peek = (MockResponse)this.responseQueue.peek();
        if (peek != null) {
            return peek;
        }
        if (this.failFastResponse != null) {
            return this.failFastResponse;
        }
        return super.peek();
    }

    public void enqueueResponse(MockResponse response) {
        this.responseQueue.add(response);
    }

    @Override
    public void shutdown() {
        this.responseQueue.add(DEAD_LETTER);
    }

    public void setFailFast(boolean failFast) {
        MockResponse failFastResponse = failFast ? new MockResponse().setResponseCode(404) : null;
        this.setFailFast(failFastResponse);
    }

    public void setFailFast(MockResponse failFastResponse) {
        this.failFastResponse = failFastResponse;
    }
}

