/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.apache;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.apache.HttpEntityBody;
import okhttp3.internal.Util;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public final class OkApacheClient
implements HttpClient {
    private final HttpParams params = new AbstractHttpParams(){

        public Object getParameter(String name) {
            if (name.equals("http.route.default-proxy")) {
                Proxy proxy = OkApacheClient.this.client.proxy();
                if (proxy == null) {
                    return null;
                }
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                return new HttpHost(address.getHostName(), address.getPort());
            }
            throw new IllegalArgumentException(name);
        }

        public HttpParams setParameter(String name, Object value) {
            if (name.equals("http.route.default-proxy")) {
                HttpHost host = (HttpHost)value;
                Proxy proxy = null;
                if (host != null) {
                    proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host.getHostName(), host.getPort()));
                }
                OkApacheClient.this.client = OkApacheClient.this.client.newBuilder().proxy(proxy).build();
                return this;
            }
            throw new IllegalArgumentException(name);
        }

        public HttpParams copy() {
            throw new UnsupportedOperationException();
        }

        public boolean removeParameter(String name) {
            throw new UnsupportedOperationException();
        }
    };
    private OkHttpClient client;

    private static Request transformRequest(HttpRequest request) {
        Request.Builder builder = new Request.Builder();
        RequestLine requestLine = request.getRequestLine();
        String method = requestLine.getMethod();
        builder.url(requestLine.getUri());
        String contentType = null;
        for (Header header : request.getAllHeaders()) {
            String name = header.getName();
            if ("Content-Type".equalsIgnoreCase(name)) {
                contentType = header.getValue();
                continue;
            }
            builder.header(name, header.getValue());
        }
        RequestBody body = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null) {
                body = new HttpEntityBody(entity, contentType);
                Header encoding = entity.getContentEncoding();
                if (encoding != null) {
                    builder.header(encoding.getName(), encoding.getValue());
                }
            } else {
                body = Util.EMPTY_REQUEST;
            }
        }
        builder.method(method, body);
        return builder.build();
    }

    private static HttpResponse transformResponse(Response response) {
        int code = response.code();
        String message = response.message();
        BasicHttpResponse httpResponse = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, code, message);
        ResponseBody body = response.body();
        InputStreamEntity entity = new InputStreamEntity(body.byteStream(), body.contentLength());
        httpResponse.setEntity((HttpEntity)entity);
        Headers headers = response.headers();
        int size = headers.size();
        for (int i = 0; i < size; ++i) {
            String name = headers.name(i);
            String value = headers.value(i);
            httpResponse.addHeader(name, value);
            if ("Content-Type".equalsIgnoreCase(name)) {
                entity.setContentType(value);
                continue;
            }
            if (!"Content-Encoding".equalsIgnoreCase(name)) continue;
            entity.setContentEncoding(value);
        }
        return httpResponse;
    }

    public OkApacheClient() {
        this(new OkHttpClient());
    }

    public OkApacheClient(OkHttpClient client) {
        this.client = client;
    }

    public HttpParams getParams() {
        return this.params;
    }

    public ClientConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return this.execute(null, (HttpRequest)request, (HttpContext)null);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        return this.execute(null, (HttpRequest)request, context);
    }

    public HttpResponse execute(HttpHost host, HttpRequest request) throws IOException {
        return this.execute(host, request, (HttpContext)null);
    }

    public HttpResponse execute(HttpHost host, HttpRequest request, HttpContext context) throws IOException {
        Request okRequest = OkApacheClient.transformRequest(request);
        Response okResponse = this.client.newCall(okRequest).execute();
        return OkApacheClient.transformResponse(okResponse);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> handler) throws IOException {
        return this.execute(null, (HttpRequest)request, handler, null);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> handler, HttpContext context) throws IOException {
        return this.execute(null, (HttpRequest)request, handler, context);
    }

    public <T> T execute(HttpHost host, HttpRequest request, ResponseHandler<? extends T> handler) throws IOException {
        return this.execute(host, request, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(HttpHost host, HttpRequest request, ResponseHandler<? extends T> handler, HttpContext context) throws IOException {
        HttpResponse response = this.execute(host, request, context);
        try {
            Object object = handler.handleResponse(response);
            return (T)object;
        }
        finally {
            OkApacheClient.consumeContentQuietly(response);
        }
    }

    private static void consumeContentQuietly(HttpResponse response) {
        try {
            response.getEntity().consumeContent();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

