/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.dnsoverhttps;

import java.io.EOFException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import okio.Buffer;
import okio.ByteString;
import okio.Utf8;

class DnsRecordCodec {
    private static final byte SERVFAIL = 2;
    private static final byte NXDOMAIN = 3;
    public static final int TYPE_A = 1;
    public static final int TYPE_AAAA = 28;
    private static final int TYPE_PTR = 12;
    private static final Charset ASCII = Charset.forName("ASCII");

    private DnsRecordCodec() {
    }

    public static ByteString encodeQuery(String host, int type) {
        String[] labels;
        Buffer buf = new Buffer();
        buf.writeShort(0);
        buf.writeShort(256);
        buf.writeShort(1);
        buf.writeShort(0);
        buf.writeShort(0);
        buf.writeShort(0);
        Buffer nameBuf = new Buffer();
        for (String label : labels = host.split("\\.")) {
            long utf8ByteCount = Utf8.size((String)label);
            if (utf8ByteCount != (long)label.length()) {
                throw new IllegalArgumentException("non-ascii hostname: " + host);
            }
            nameBuf.writeByte((int)((byte)utf8ByteCount));
            nameBuf.writeUtf8(label);
        }
        nameBuf.writeByte(0);
        nameBuf.copyTo(buf, 0L, nameBuf.size());
        buf.writeShort(type);
        buf.writeShort(1);
        return buf.readByteString();
    }

    public static List<InetAddress> decodeAnswers(String hostname, ByteString byteString) throws Exception {
        int i;
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        Buffer buf = new Buffer();
        buf.write(byteString);
        buf.readShort();
        int flags = buf.readShort() & 0xFFFF;
        if (flags >> 15 == 0) {
            throw new IllegalArgumentException("not a response");
        }
        byte responseCode = (byte)(flags & 0xF);
        if (responseCode == 3) {
            throw new UnknownHostException(hostname + ": NXDOMAIN");
        }
        if (responseCode == 2) {
            throw new UnknownHostException(hostname + ": SERVFAIL");
        }
        int questionCount = buf.readShort() & 0xFFFF;
        int answerCount = buf.readShort() & 0xFFFF;
        buf.readShort();
        buf.readShort();
        for (i = 0; i < questionCount; ++i) {
            DnsRecordCodec.skipName(buf);
            buf.readShort();
            buf.readShort();
        }
        for (i = 0; i < answerCount; ++i) {
            DnsRecordCodec.skipName(buf);
            int type = buf.readShort() & 0xFFFF;
            buf.readShort();
            long ttl = (long)buf.readInt() & 0xFFFFFFFFL;
            int length = buf.readShort() & 0xFFFF;
            if (type == 1 || type == 28) {
                byte[] bytes = new byte[length];
                buf.read(bytes);
                result.add(InetAddress.getByAddress(bytes));
                continue;
            }
            buf.skip((long)length);
        }
        return result;
    }

    private static void skipName(Buffer in) throws EOFException {
        byte length = in.readByte();
        if (length < 0) {
            in.skip(1L);
        } else {
            while (length > 0) {
                in.skip((long)length);
                length = in.readByte();
            }
        }
    }
}

