/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.spoon;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import com.squareup.spoon.Chmod;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Pattern;

public final class Spoon {
    static final String SPOON_SCREENSHOTS = "spoon-screenshots";
    static final String SPOON_FILES = "spoon-files";
    static final String NAME_SEPARATOR = "_";
    static final String TEST_CASE_CLASS_JUNIT_3 = "android.test.InstrumentationTestCase";
    static final String TEST_CASE_METHOD_JUNIT_3 = "runMethod";
    static final String TEST_CASE_CLASS_JUNIT_4 = "org.junit.runners.model.FrameworkMethod$1";
    static final String TEST_CASE_METHOD_JUNIT_4 = "runReflectiveCall";
    static final String TEST_CASE_CLASS_CUCUMBER_JVM = "cucumber.runtime.model.CucumberFeature";
    static final String TEST_CASE_METHOD_CUCUMBER_JVM = "run";
    private static final String EXTENSION = ".png";
    private static final String TAG = "Spoon";
    private static final Object LOCK = new Object();
    private static final Pattern TAG_VALIDATION = Pattern.compile("[a-zA-Z0-9_-]+");
    private static Set<String> clearedOutputDirectories = new HashSet<String>();

    public static File screenshot(Activity activity, String tag) {
        StackTraceElement testClass = Spoon.findTestClassTraceElement(Thread.currentThread().getStackTrace());
        String className = testClass.getClassName().replaceAll("[^A-Za-z0-9._-]", NAME_SEPARATOR);
        String methodName = testClass.getMethodName();
        return Spoon.screenshot(activity, tag, className, methodName);
    }

    public static File screenshot(Activity activity, String tag, String testClassName, String testMethodName) {
        if (!TAG_VALIDATION.matcher(tag).matches()) {
            throw new IllegalArgumentException("Tag must match " + TAG_VALIDATION.pattern() + ".");
        }
        try {
            File screenshotDirectory = Spoon.obtainScreenshotDirectory(activity.getApplicationContext(), testClassName, testMethodName);
            String screenshotName = System.currentTimeMillis() + NAME_SEPARATOR + tag + EXTENSION;
            File screenshotFile = new File(screenshotDirectory, screenshotName);
            Spoon.takeScreenshot(screenshotFile, activity);
            Log.d((String)TAG, (String)("Captured screenshot '" + tag + "'."));
            return screenshotFile;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to capture screenshot.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void takeScreenshot(File file, final Activity activity) throws IOException {
        View view = activity.getWindow().getDecorView();
        final Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            Spoon.drawDecorViewToBitmap(activity, bitmap);
        } else {
            final CountDownLatch latch = new CountDownLatch(1);
            activity.runOnUiThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Spoon.drawDecorViewToBitmap(activity, bitmap);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                String msg = "Unable to get screenshot " + file.getAbsolutePath();
                Log.e((String)TAG, (String)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
        BufferedOutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            Chmod.chmodPlusR(file);
        }
        finally {
            bitmap.recycle();
            if (fos != null) {
                ((OutputStream)fos).close();
            }
        }
    }

    private static void drawDecorViewToBitmap(Activity activity, Bitmap bitmap) {
        Canvas canvas = new Canvas(bitmap);
        activity.getWindow().getDecorView().draw(canvas);
    }

    private static File obtainScreenshotDirectory(Context context, String testClassName, String testMethodName) throws IllegalAccessException {
        return Spoon.filesDirectory(context, SPOON_SCREENSHOTS, testClassName, testMethodName);
    }

    public static File save(Context context, String path) {
        return Spoon.save(context, new File(path));
    }

    public static File save(Context context, File file) {
        StackTraceElement testClass = Spoon.findTestClassTraceElement(Thread.currentThread().getStackTrace());
        String className = testClass.getClassName().replaceAll("[^A-Za-z0-9._-]", NAME_SEPARATOR);
        String methodName = testClass.getMethodName();
        return Spoon.save(context, className, methodName, file);
    }

    private static File save(Context context, String className, String methodName, File file) {
        File filesDirectory = null;
        try {
            filesDirectory = Spoon.filesDirectory(context, SPOON_FILES, className, methodName);
            if (!file.exists()) {
                throw new RuntimeException("Can't find any file at: " + file);
            }
            File target = new File(filesDirectory, file.getName());
            Spoon.copy(file, target);
            Log.d((String)TAG, (String)("Saved " + file));
            return target;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to save file: " + file);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't copy file " + file + " to " + filesDirectory);
        }
    }

    private static void copy(File source, File target) throws IOException {
        Log.d((String)TAG, (String)("Will copy " + source + " to " + target));
        target.createNewFile();
        Chmod.chmodPlusR(target);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(target));
        byte[] buffer = new byte[4096];
        while (is.read(buffer) > 0) {
            os.write(buffer);
        }
        is.close();
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File filesDirectory(Context context, String directoryType, String testClassName, String testMethodName) throws IllegalAccessException {
        File directory = Build.VERSION.SDK_INT >= 21 ? new File(Environment.getExternalStorageDirectory(), "app_" + directoryType) : context.getDir(directoryType, 1);
        Object object = LOCK;
        synchronized (object) {
            if (!clearedOutputDirectories.contains(directoryType)) {
                Spoon.deletePath(directory, false);
                clearedOutputDirectories.add(directoryType);
            }
        }
        File dirClass = new File(directory, testClassName);
        File dirMethod = new File(dirClass, testMethodName);
        Spoon.createDir(dirMethod);
        return dirMethod;
    }

    static StackTraceElement findTestClassTraceElement(StackTraceElement[] trace) {
        for (int i = trace.length - 1; i >= 0; --i) {
            StackTraceElement element = trace[i];
            if (TEST_CASE_CLASS_JUNIT_3.equals(element.getClassName()) && TEST_CASE_METHOD_JUNIT_3.equals(element.getMethodName())) {
                return Spoon.extractStackElement(trace, i);
            }
            if (TEST_CASE_CLASS_JUNIT_4.equals(element.getClassName()) && TEST_CASE_METHOD_JUNIT_4.equals(element.getMethodName())) {
                return Spoon.extractStackElement(trace, i);
            }
            if (!TEST_CASE_CLASS_CUCUMBER_JVM.equals(element.getClassName()) || !TEST_CASE_METHOD_CUCUMBER_JVM.equals(element.getMethodName())) continue;
            return Spoon.extractStackElement(trace, i);
        }
        throw new IllegalArgumentException("Could not find test class!");
    }

    private static StackTraceElement extractStackElement(StackTraceElement[] trace, int i) {
        int testClassTraceIndex = Build.VERSION.SDK_INT >= 23 ? i - 2 : i - 3;
        return trace[testClassTraceIndex];
    }

    private static void createDir(File dir) throws IllegalAccessException {
        File parent = dir.getParentFile();
        if (!parent.exists()) {
            Spoon.createDir(parent);
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalAccessException("Unable to create output dir: " + dir.getAbsolutePath());
        }
        Chmod.chmodPlusRWX(dir);
    }

    private static void deletePath(File path, boolean inclusive) {
        File[] children;
        if (path.isDirectory() && (children = path.listFiles()) != null) {
            for (File child : children) {
                Spoon.deletePath(child, true);
            }
        }
        if (inclusive) {
            path.delete();
        }
    }

    private Spoon() {
    }
}

