/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.account;

import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Function;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.account.DefaultAccountResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.json.JsonFunction;
import com.stormpath.sdk.servlet.json.ResourceJsonFunction;
import com.stormpath.sdk.servlet.mvc.ResourceMapFunction;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccountStringResolver
implements Resolver<String> {
    private Function<Account, String> accountStringFunction;
    private AccountResolver accountResolver = new DefaultAccountResolver();

    public AccountStringResolver() {
        ResourceMapFunction mapFunction = new ResourceMapFunction();
        mapFunction.setIncludedFields(Collections.toSet((Object[])new String[]{"groups"}));
        this.accountStringFunction = new ResourceJsonFunction<Account>(mapFunction, new JsonFunction<Object>());
    }

    public void setAccountStringFunction(Function<Account, String> accountStringFunction) {
        Assert.notNull(accountStringFunction, (String)"accountStringFunction cannot be null.");
        this.accountStringFunction = accountStringFunction;
    }

    public void setAccountResolver(AccountResolver accountResolver) {
        Assert.notNull((Object)accountResolver, (String)"accountResolver cannot be null.");
        this.accountResolver = accountResolver;
    }

    @Override
    public String get(HttpServletRequest request, HttpServletResponse response) {
        Account account = this.accountResolver.getAccount((ServletRequest)request);
        if (account != null) {
            return (String)this.accountStringFunction.apply((Object)account);
        }
        return null;
    }
}

