/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.application;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationList;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.config.Config;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

public class DefaultApplicationResolver
implements ApplicationResolver {
    public static final String STORMPATH_APPLICATION_HREF = "stormpath.application.href";
    private static final String APP_HREF_ERROR = "The application's stormpath.properties configuration does not have a stormpath.application.href property defined.  This property is required when looking up an application by ServletContext and you have more than one application registered in Stormpath.  For example:\n\n # in stormpath.properties:\n stormpath.application.href = YOUR_STORMPATH_APPLICATION_HREF_HERE\n";

    protected Client getClient(ServletContext sc) {
        Client client = (Client)sc.getAttribute(Client.class.getName());
        Assert.notNull((Object)client, (String)"Stormpath Client instance is not available in the ServletContext.  Ensure the ClientLoaderListener is defined before the ApplicationLoaderListener.");
        return client;
    }

    protected Config getConfig(ServletContext servletContext) {
        Config config = (Config)servletContext.getAttribute(Config.class.getName());
        Assert.notNull((Object)config, (String)"Stormpath Config instance is not available in the ServletContext.  Ensure the ConfigLoaderListener is defined before the ApplicationLoaderListener.");
        return config;
    }

    @Override
    public Application getApplication(ServletRequest servletRequest) {
        Object attribute = servletRequest.getAttribute(Application.class.getName());
        if (attribute != null) {
            Assert.isInstanceOf(Application.class, (Object)attribute);
            return (Application)attribute;
        }
        return this.getApplication(servletRequest.getServletContext());
    }

    @Override
    public Application getApplication(ServletContext servletContext) {
        Application application;
        Assert.notNull((Object)servletContext, (String)"ServletContext argument cannot be null.");
        Object attribute = servletContext.getAttribute(Application.class.getName());
        if (attribute != null) {
            Assert.isInstanceOf(Application.class, (Object)attribute);
            return (Application)attribute;
        }
        Client client = this.getClient(servletContext);
        String href = (String)servletContext.getAttribute(STORMPATH_APPLICATION_HREF);
        if (href == null) {
            Config config = this.getConfig(servletContext);
            href = (String)config.get(STORMPATH_APPLICATION_HREF);
        }
        if (href == null) {
            ApplicationList apps = client.getApplications();
            Application single = null;
            for (Application app : apps) {
                if (app.getName().equalsIgnoreCase("Stormpath")) continue;
                if (single != null) {
                    throw new IllegalStateException(APP_HREF_ERROR);
                }
                single = app;
            }
            if (single != null) {
                servletContext.setAttribute(STORMPATH_APPLICATION_HREF, (Object)single.getHref());
            }
            application = single;
        } else {
            Assert.hasText((String)href, (String)"The specified stormpath.application.href property value cannot be empty.");
            try {
                application = (Application)client.getResource(href, Application.class);
            }
            catch (Exception e) {
                String msg = "Unable to lookup Stormpath application reference by stormpath.application.href [" + href + "].  Please ensure this href is accurate and reflects an application " + "registered in Stormpath.";
                throw new IllegalArgumentException(msg, e);
            }
        }
        servletContext.setAttribute(Application.class.getName(), (Object)application);
        return application;
    }
}

